package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSnapshotSettings invokes the r_kvstore.GetSnapshotSettings API synchronously
// api document: https://help.aliyun.com/api/r-kvstore/getsnapshotsettings.html
func (client *Client) GetSnapshotSettings(request *GetSnapshotSettingsRequest) (response *GetSnapshotSettingsResponse, err error) {
	response = CreateGetSnapshotSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// GetSnapshotSettingsWithChan invokes the r_kvstore.GetSnapshotSettings API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/getsnapshotsettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSnapshotSettingsWithChan(request *GetSnapshotSettingsRequest) (<-chan *GetSnapshotSettingsResponse, <-chan error) {
	responseChan := make(chan *GetSnapshotSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSnapshotSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSnapshotSettingsWithCallback invokes the r_kvstore.GetSnapshotSettings API asynchronously
// api document: https://help.aliyun.com/api/r-kvstore/getsnapshotsettings.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetSnapshotSettingsWithCallback(request *GetSnapshotSettingsRequest, callback func(response *GetSnapshotSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSnapshotSettingsResponse
		var err error
		defer close(result)
		response, err = client.GetSnapshotSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSnapshotSettingsRequest is the request struct for api GetSnapshotSettings
type GetSnapshotSettingsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// GetSnapshotSettingsResponse is the response struct for api GetSnapshotSettings
type GetSnapshotSettingsResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	InstanceId         string `json:"InstanceId" xml:"InstanceId"`
	BeginHour          int    `json:"BeginHour" xml:"BeginHour"`
	EndHour            int    `json:"EndHour" xml:"EndHour"`
	RetentionDay       int    `json:"RetentionDay" xml:"RetentionDay"`
	MaxAutoSnapshots   int    `json:"MaxAutoSnapshots" xml:"MaxAutoSnapshots"`
	MaxManualSnapshots int    `json:"MaxManualSnapshots" xml:"MaxManualSnapshots"`
	DayList            int    `json:"DayList" xml:"DayList"`
	NextTime           string `json:"NextTime" xml:"NextTime"`
}

// CreateGetSnapshotSettingsRequest creates a request to invoke GetSnapshotSettings API
func CreateGetSnapshotSettingsRequest() (request *GetSnapshotSettingsRequest) {
	request = &GetSnapshotSettingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "GetSnapshotSettings", "", "")
	return
}

// CreateGetSnapshotSettingsResponse creates a response to parse from GetSnapshotSettings response
func CreateGetSnapshotSettingsResponse() (response *GetSnapshotSettingsResponse) {
	response = &GetSnapshotSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
