package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceNetworkExpireTime invokes the rds.ModifyDBInstanceNetworkExpireTime API synchronously
// api document: https://help.aliyun.com/api/rds/modifydbinstancenetworkexpiretime.html
func (client *Client) ModifyDBInstanceNetworkExpireTime(request *ModifyDBInstanceNetworkExpireTimeRequest) (response *ModifyDBInstanceNetworkExpireTimeResponse, err error) {
	response = CreateModifyDBInstanceNetworkExpireTimeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceNetworkExpireTimeWithChan invokes the rds.ModifyDBInstanceNetworkExpireTime API asynchronously
// api document: https://help.aliyun.com/api/rds/modifydbinstancenetworkexpiretime.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDBInstanceNetworkExpireTimeWithChan(request *ModifyDBInstanceNetworkExpireTimeRequest) (<-chan *ModifyDBInstanceNetworkExpireTimeResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceNetworkExpireTimeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceNetworkExpireTime(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceNetworkExpireTimeWithCallback invokes the rds.ModifyDBInstanceNetworkExpireTime API asynchronously
// api document: https://help.aliyun.com/api/rds/modifydbinstancenetworkexpiretime.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyDBInstanceNetworkExpireTimeWithCallback(request *ModifyDBInstanceNetworkExpireTimeRequest, callback func(response *ModifyDBInstanceNetworkExpireTimeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceNetworkExpireTimeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceNetworkExpireTime(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceNetworkExpireTimeRequest is the request struct for api ModifyDBInstanceNetworkExpireTime
type ModifyDBInstanceNetworkExpireTimeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ConnectionString     string           `position:"Query" name:"ConnectionString"`
	ClassicExpiredDays   requests.Integer `position:"Query" name:"ClassicExpiredDays"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyDBInstanceNetworkExpireTimeResponse is the response struct for api ModifyDBInstanceNetworkExpireTime
type ModifyDBInstanceNetworkExpireTimeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBInstanceNetworkExpireTimeRequest creates a request to invoke ModifyDBInstanceNetworkExpireTime API
func CreateModifyDBInstanceNetworkExpireTimeRequest() (request *ModifyDBInstanceNetworkExpireTimeRequest) {
	request = &ModifyDBInstanceNetworkExpireTimeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "ModifyDBInstanceNetworkExpireTime", "rds", "openAPI")
	return
}

// CreateModifyDBInstanceNetworkExpireTimeResponse creates a response to parse from ModifyDBInstanceNetworkExpireTime response
func CreateModifyDBInstanceNetworkExpireTimeResponse() (response *ModifyDBInstanceNetworkExpireTimeResponse) {
	response = &ModifyDBInstanceNetworkExpireTimeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
