package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeApplicationInstances invokes the sae.DescribeApplicationInstances API synchronously
// api document: https://help.aliyun.com/api/sae/describeapplicationinstances.html
func (client *Client) DescribeApplicationInstances(request *DescribeApplicationInstancesRequest) (response *DescribeApplicationInstancesResponse, err error) {
	response = CreateDescribeApplicationInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeApplicationInstancesWithChan invokes the sae.DescribeApplicationInstances API asynchronously
// api document: https://help.aliyun.com/api/sae/describeapplicationinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeApplicationInstancesWithChan(request *DescribeApplicationInstancesRequest) (<-chan *DescribeApplicationInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeApplicationInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeApplicationInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeApplicationInstancesWithCallback invokes the sae.DescribeApplicationInstances API asynchronously
// api document: https://help.aliyun.com/api/sae/describeapplicationinstances.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeApplicationInstancesWithCallback(request *DescribeApplicationInstancesRequest, callback func(response *DescribeApplicationInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeApplicationInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeApplicationInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeApplicationInstancesRequest is the request struct for api DescribeApplicationInstances
type DescribeApplicationInstancesRequest struct {
	*requests.RoaRequest
	AppId       string           `position:"Query" name:"AppId"`
	GroupId     string           `position:"Query" name:"GroupId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
}

// DescribeApplicationInstancesResponse is the response struct for api DescribeApplicationInstances
type DescribeApplicationInstancesResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeApplicationInstancesRequest creates a request to invoke DescribeApplicationInstances API
func CreateDescribeApplicationInstancesRequest() (request *DescribeApplicationInstancesRequest) {
	request = &DescribeApplicationInstancesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DescribeApplicationInstances", "/pop/v1/sam/app/describeApplicationInstances", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeApplicationInstancesResponse creates a response to parse from DescribeApplicationInstances response
func CreateDescribeApplicationInstancesResponse() (response *DescribeApplicationInstancesResponse) {
	response = &DescribeApplicationInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
