package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeChangeOrder invokes the sae.DescribeChangeOrder API synchronously
// api document: https://help.aliyun.com/api/sae/describechangeorder.html
func (client *Client) DescribeChangeOrder(request *DescribeChangeOrderRequest) (response *DescribeChangeOrderResponse, err error) {
	response = CreateDescribeChangeOrderResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeChangeOrderWithChan invokes the sae.DescribeChangeOrder API asynchronously
// api document: https://help.aliyun.com/api/sae/describechangeorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeChangeOrderWithChan(request *DescribeChangeOrderRequest) (<-chan *DescribeChangeOrderResponse, <-chan error) {
	responseChan := make(chan *DescribeChangeOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeChangeOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeChangeOrderWithCallback invokes the sae.DescribeChangeOrder API asynchronously
// api document: https://help.aliyun.com/api/sae/describechangeorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeChangeOrderWithCallback(request *DescribeChangeOrderRequest, callback func(response *DescribeChangeOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeChangeOrderResponse
		var err error
		defer close(result)
		response, err = client.DescribeChangeOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeChangeOrderRequest is the request struct for api DescribeChangeOrder
type DescribeChangeOrderRequest struct {
	*requests.RoaRequest
	ChangeOrderId string `position:"Query" name:"ChangeOrderId"`
}

// DescribeChangeOrderResponse is the response struct for api DescribeChangeOrder
type DescribeChangeOrderResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Message   string `json:"Message" xml:"Message"`
	Success   bool   `json:"Success" xml:"Success"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeChangeOrderRequest creates a request to invoke DescribeChangeOrder API
func CreateDescribeChangeOrderRequest() (request *DescribeChangeOrderRequest) {
	request = &DescribeChangeOrderRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "DescribeChangeOrder", "/pop/v1/sam/changeorder/DescribeChangeOrder", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeChangeOrderResponse creates a response to parse from DescribeChangeOrder response
func CreateDescribeChangeOrderResponse() (response *DescribeChangeOrderResponse) {
	response = &DescribeChangeOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
