package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAuthAccounts invokes the sddp.DescribeAuthAccounts API synchronously
// api document: https://help.aliyun.com/api/sddp/describeauthaccounts.html
func (client *Client) DescribeAuthAccounts(request *DescribeAuthAccountsRequest) (response *DescribeAuthAccountsResponse, err error) {
	response = CreateDescribeAuthAccountsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAuthAccountsWithChan invokes the sddp.DescribeAuthAccounts API asynchronously
// api document: https://help.aliyun.com/api/sddp/describeauthaccounts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAuthAccountsWithChan(request *DescribeAuthAccountsRequest) (<-chan *DescribeAuthAccountsResponse, <-chan error) {
	responseChan := make(chan *DescribeAuthAccountsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAuthAccounts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAuthAccountsWithCallback invokes the sddp.DescribeAuthAccounts API asynchronously
// api document: https://help.aliyun.com/api/sddp/describeauthaccounts.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeAuthAccountsWithCallback(request *DescribeAuthAccountsRequest, callback func(response *DescribeAuthAccountsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAuthAccountsResponse
		var err error
		defer close(result)
		response, err = client.DescribeAuthAccounts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAuthAccountsRequest is the request struct for api DescribeAuthAccounts
type DescribeAuthAccountsRequest struct {
	*requests.RpcRequest
	SourceIp    string           `position:"Query" name:"SourceIp"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeAuthAccountsResponse is the response struct for api DescribeAuthAccounts
type DescribeAuthAccountsResponse struct {
	*responses.BaseResponse
	RequestId   string    `json:"RequestId" xml:"RequestId"`
	PageSize    int       `json:"PageSize" xml:"PageSize"`
	CurrentPage int       `json:"CurrentPage" xml:"CurrentPage"`
	TotalCount  int       `json:"TotalCount" xml:"TotalCount"`
	Items       []Account `json:"Items" xml:"Items"`
}

// CreateDescribeAuthAccountsRequest creates a request to invoke DescribeAuthAccounts API
func CreateDescribeAuthAccountsRequest() (request *DescribeAuthAccountsRequest) {
	request = &DescribeAuthAccountsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeAuthAccounts", "sddp", "openAPI")
	return
}

// CreateDescribeAuthAccountsResponse creates a response to parse from DescribeAuthAccounts response
func CreateDescribeAuthAccountsResponse() (response *DescribeAuthAccountsResponse) {
	response = &DescribeAuthAccountsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
