package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindSerialNumber invokes the smartag.BindSerialNumber API synchronously
// api document: https://help.aliyun.com/api/smartag/bindserialnumber.html
func (client *Client) BindSerialNumber(request *BindSerialNumberRequest) (response *BindSerialNumberResponse, err error) {
	response = CreateBindSerialNumberResponse()
	err = client.DoAction(request, response)
	return
}

// BindSerialNumberWithChan invokes the smartag.BindSerialNumber API asynchronously
// api document: https://help.aliyun.com/api/smartag/bindserialnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindSerialNumberWithChan(request *BindSerialNumberRequest) (<-chan *BindSerialNumberResponse, <-chan error) {
	responseChan := make(chan *BindSerialNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindSerialNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindSerialNumberWithCallback invokes the smartag.BindSerialNumber API asynchronously
// api document: https://help.aliyun.com/api/smartag/bindserialnumber.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindSerialNumberWithCallback(request *BindSerialNumberRequest, callback func(response *BindSerialNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindSerialNumberResponse
		var err error
		defer close(result)
		response, err = client.BindSerialNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindSerialNumberRequest is the request struct for api BindSerialNumber
type BindSerialNumberRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SerialNumber         string           `position:"Query" name:"SerialNumber"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// BindSerialNumberResponse is the response struct for api BindSerialNumber
type BindSerialNumberResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindSerialNumberRequest creates a request to invoke BindSerialNumber API
func CreateBindSerialNumberRequest() (request *BindSerialNumberRequest) {
	request = &BindSerialNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "BindSerialNumber", "smartag", "openAPI")
	return
}

// CreateBindSerialNumberResponse creates a response to parse from BindSerialNumber response
func CreateBindSerialNumberResponse() (response *BindSerialNumberResponse) {
	response = &BindSerialNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
