package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSagECRouteBackupAttribute invokes the smartag.DescribeSagECRouteBackupAttribute API synchronously
// api document: https://help.aliyun.com/api/smartag/describesagecroutebackupattribute.html
func (client *Client) DescribeSagECRouteBackupAttribute(request *DescribeSagECRouteBackupAttributeRequest) (response *DescribeSagECRouteBackupAttributeResponse, err error) {
	response = CreateDescribeSagECRouteBackupAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSagECRouteBackupAttributeWithChan invokes the smartag.DescribeSagECRouteBackupAttribute API asynchronously
// api document: https://help.aliyun.com/api/smartag/describesagecroutebackupattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSagECRouteBackupAttributeWithChan(request *DescribeSagECRouteBackupAttributeRequest) (<-chan *DescribeSagECRouteBackupAttributeResponse, <-chan error) {
	responseChan := make(chan *DescribeSagECRouteBackupAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSagECRouteBackupAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSagECRouteBackupAttributeWithCallback invokes the smartag.DescribeSagECRouteBackupAttribute API asynchronously
// api document: https://help.aliyun.com/api/smartag/describesagecroutebackupattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeSagECRouteBackupAttributeWithCallback(request *DescribeSagECRouteBackupAttributeRequest, callback func(response *DescribeSagECRouteBackupAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSagECRouteBackupAttributeResponse
		var err error
		defer close(result)
		response, err = client.DescribeSagECRouteBackupAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSagECRouteBackupAttributeRequest is the request struct for api DescribeSagECRouteBackupAttribute
type DescribeSagECRouteBackupAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
}

// DescribeSagECRouteBackupAttributeResponse is the response struct for api DescribeSagECRouteBackupAttribute
type DescribeSagECRouteBackupAttributeResponse struct {
	*responses.BaseResponse
	RequestId                  string `json:"RequestId" xml:"RequestId"`
	SagId                      string `json:"SagId" xml:"SagId"`
	HcIp                       string `json:"HcIp" xml:"HcIp"`
	ExpressConnectionInterface string `json:"ExpressConnectionInterface" xml:"ExpressConnectionInterface"`
	ExpressConnectionNexthop   string `json:"ExpressConnectionNexthop" xml:"ExpressConnectionNexthop"`
	RouteBackup                bool   `json:"RouteBackup" xml:"RouteBackup"`
	Status                     string `json:"Status" xml:"Status"`
	Cidrs                      Cidrs  `json:"Cidrs" xml:"Cidrs"`
}

// CreateDescribeSagECRouteBackupAttributeRequest creates a request to invoke DescribeSagECRouteBackupAttribute API
func CreateDescribeSagECRouteBackupAttributeRequest() (request *DescribeSagECRouteBackupAttributeRequest) {
	request = &DescribeSagECRouteBackupAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSagECRouteBackupAttribute", "smartag", "openAPI")
	return
}

// CreateDescribeSagECRouteBackupAttributeResponse creates a response to parse from DescribeSagECRouteBackupAttribute response
func CreateDescribeSagECRouteBackupAttributeResponse() (response *DescribeSagECRouteBackupAttributeResponse) {
	response = &DescribeSagECRouteBackupAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
