package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHealthCheck invokes the smartag.ModifyHealthCheck API synchronously
// api document: https://help.aliyun.com/api/smartag/modifyhealthcheck.html
func (client *Client) ModifyHealthCheck(request *ModifyHealthCheckRequest) (response *ModifyHealthCheckResponse, err error) {
	response = CreateModifyHealthCheckResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHealthCheckWithChan invokes the smartag.ModifyHealthCheck API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifyhealthcheck.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyHealthCheckWithChan(request *ModifyHealthCheckRequest) (<-chan *ModifyHealthCheckResponse, <-chan error) {
	responseChan := make(chan *ModifyHealthCheckResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHealthCheck(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHealthCheckWithCallback invokes the smartag.ModifyHealthCheck API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifyhealthcheck.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyHealthCheckWithCallback(request *ModifyHealthCheckRequest, callback func(response *ModifyHealthCheckResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHealthCheckResponse
		var err error
		defer close(result)
		response, err = client.ModifyHealthCheck(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHealthCheckRequest is the request struct for api ModifyHealthCheck
type ModifyHealthCheckRequest struct {
	*requests.RpcRequest
	ProbeInterval        requests.Integer `position:"Query" name:"ProbeInterval"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DstPort              requests.Integer `position:"Query" name:"DstPort"`
	Description          string           `position:"Query" name:"Description"`
	HcInstanceId         string           `position:"Query" name:"HcInstanceId"`
	Type                 string           `position:"Query" name:"Type"`
	FailCountThreshold   requests.Integer `position:"Query" name:"FailCountThreshold"`
	ProbeTimeout         requests.Integer `position:"Query" name:"ProbeTimeout"`
	RttFailThreshold     requests.Integer `position:"Query" name:"RttFailThreshold"`
	RttThreshold         requests.Integer `position:"Query" name:"RttThreshold"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	DstIpAddr            string           `position:"Query" name:"DstIpAddr"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SrcIpAddr            string           `position:"Query" name:"SrcIpAddr"`
	Name                 string           `position:"Query" name:"Name"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SrcPort              requests.Integer `position:"Query" name:"SrcPort"`
	ProbeCount           requests.Integer `position:"Query" name:"ProbeCount"`
}

// ModifyHealthCheckResponse is the response struct for api ModifyHealthCheck
type ModifyHealthCheckResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyHealthCheckRequest creates a request to invoke ModifyHealthCheck API
func CreateModifyHealthCheckRequest() (request *ModifyHealthCheckRequest) {
	request = &ModifyHealthCheckRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifyHealthCheck", "smartag", "openAPI")
	return
}

// CreateModifyHealthCheckResponse creates a response to parse from ModifyHealthCheck response
func CreateModifyHealthCheckResponse() (response *ModifyHealthCheckResponse) {
	response = &ModifyHealthCheckResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
