package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifySagECRouteBackup invokes the smartag.ModifySagECRouteBackup API synchronously
// api document: https://help.aliyun.com/api/smartag/modifysagecroutebackup.html
func (client *Client) ModifySagECRouteBackup(request *ModifySagECRouteBackupRequest) (response *ModifySagECRouteBackupResponse, err error) {
	response = CreateModifySagECRouteBackupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifySagECRouteBackupWithChan invokes the smartag.ModifySagECRouteBackup API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifysagecroutebackup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySagECRouteBackupWithChan(request *ModifySagECRouteBackupRequest) (<-chan *ModifySagECRouteBackupResponse, <-chan error) {
	responseChan := make(chan *ModifySagECRouteBackupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifySagECRouteBackup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifySagECRouteBackupWithCallback invokes the smartag.ModifySagECRouteBackup API asynchronously
// api document: https://help.aliyun.com/api/smartag/modifysagecroutebackup.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifySagECRouteBackupWithCallback(request *ModifySagECRouteBackupRequest, callback func(response *ModifySagECRouteBackupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifySagECRouteBackupResponse
		var err error
		defer close(result)
		response, err = client.ModifySagECRouteBackup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifySagECRouteBackupRequest is the request struct for api ModifySagECRouteBackup
type ModifySagECRouteBackupRequest struct {
	*requests.RpcRequest
	ResourceOwnerId            requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExpressConnectionInterface string           `position:"Query" name:"ExpressConnectionInterface"`
	HcIp                       string           `position:"Query" name:"HcIp"`
	RouteBackup                requests.Boolean `position:"Query" name:"RouteBackup"`
	ResourceOwnerAccount       string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount               string           `position:"Query" name:"OwnerAccount"`
	OwnerId                    requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId                  string           `position:"Query" name:"SmartAGId"`
	ExpressConnectionNexthop   string           `position:"Query" name:"ExpressConnectionNexthop"`
}

// ModifySagECRouteBackupResponse is the response struct for api ModifySagECRouteBackup
type ModifySagECRouteBackupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifySagECRouteBackupRequest creates a request to invoke ModifySagECRouteBackup API
func CreateModifySagECRouteBackupRequest() (request *ModifySagECRouteBackupRequest) {
	request = &ModifySagECRouteBackupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "ModifySagECRouteBackup", "smartag", "openAPI")
	return
}

// CreateModifySagECRouteBackupResponse creates a response to parse from ModifySagECRouteBackup response
func CreateModifySagECRouteBackupResponse() (response *ModifySagECRouteBackupResponse) {
	response = &ModifySagECRouteBackupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
