package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokeInstanceFromCbn invokes the smartag.RevokeInstanceFromCbn API synchronously
// api document: https://help.aliyun.com/api/smartag/revokeinstancefromcbn.html
func (client *Client) RevokeInstanceFromCbn(request *RevokeInstanceFromCbnRequest) (response *RevokeInstanceFromCbnResponse, err error) {
	response = CreateRevokeInstanceFromCbnResponse()
	err = client.DoAction(request, response)
	return
}

// RevokeInstanceFromCbnWithChan invokes the smartag.RevokeInstanceFromCbn API asynchronously
// api document: https://help.aliyun.com/api/smartag/revokeinstancefromcbn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RevokeInstanceFromCbnWithChan(request *RevokeInstanceFromCbnRequest) (<-chan *RevokeInstanceFromCbnResponse, <-chan error) {
	responseChan := make(chan *RevokeInstanceFromCbnResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokeInstanceFromCbn(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokeInstanceFromCbnWithCallback invokes the smartag.RevokeInstanceFromCbn API asynchronously
// api document: https://help.aliyun.com/api/smartag/revokeinstancefromcbn.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RevokeInstanceFromCbnWithCallback(request *RevokeInstanceFromCbnRequest, callback func(response *RevokeInstanceFromCbnResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokeInstanceFromCbnResponse
		var err error
		defer close(result)
		response, err = client.RevokeInstanceFromCbn(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokeInstanceFromCbnRequest is the request struct for api RevokeInstanceFromCbn
type RevokeInstanceFromCbnRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CcnInstanceId        string           `position:"Query" name:"CcnInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	CenInstanceId        string           `position:"Query" name:"CenInstanceId"`
}

// RevokeInstanceFromCbnResponse is the response struct for api RevokeInstanceFromCbn
type RevokeInstanceFromCbnResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRevokeInstanceFromCbnRequest creates a request to invoke RevokeInstanceFromCbn API
func CreateRevokeInstanceFromCbnRequest() (request *RevokeInstanceFromCbnRequest) {
	request = &RevokeInstanceFromCbnRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "RevokeInstanceFromCbn", "smartag", "openAPI")
	return
}

// CreateRevokeInstanceFromCbnResponse creates a response to parse from RevokeInstanceFromCbn response
func CreateRevokeInstanceFromCbnResponse() (response *RevokeInstanceFromCbnResponse) {
	response = &RevokeInstanceFromCbnResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
