package smc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StartReplicationJob invokes the smc.StartReplicationJob API synchronously
// api document: https://help.aliyun.com/api/smc/startreplicationjob.html
func (client *Client) StartReplicationJob(request *StartReplicationJobRequest) (response *StartReplicationJobResponse, err error) {
	response = CreateStartReplicationJobResponse()
	err = client.DoAction(request, response)
	return
}

// StartReplicationJobWithChan invokes the smc.StartReplicationJob API asynchronously
// api document: https://help.aliyun.com/api/smc/startreplicationjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartReplicationJobWithChan(request *StartReplicationJobRequest) (<-chan *StartReplicationJobResponse, <-chan error) {
	responseChan := make(chan *StartReplicationJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StartReplicationJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StartReplicationJobWithCallback invokes the smc.StartReplicationJob API asynchronously
// api document: https://help.aliyun.com/api/smc/startreplicationjob.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) StartReplicationJobWithCallback(request *StartReplicationJobRequest, callback func(response *StartReplicationJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StartReplicationJobResponse
		var err error
		defer close(result)
		response, err = client.StartReplicationJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StartReplicationJobRequest is the request struct for api StartReplicationJob
type StartReplicationJobRequest struct {
	*requests.RpcRequest
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	JobId                string           `position:"Query" name:"JobId"`
}

// StartReplicationJobResponse is the response struct for api StartReplicationJob
type StartReplicationJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStartReplicationJobRequest creates a request to invoke StartReplicationJob API
func CreateStartReplicationJobRequest() (request *StartReplicationJobRequest) {
	request = &StartReplicationJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("smc", "2019-06-01", "StartReplicationJob", "smc", "openAPI")
	return
}

// CreateStartReplicationJobResponse creates a response to parse from StartReplicationJob response
func CreateStartReplicationJobResponse() (response *StartReplicationJobResponse) {
	response = &StartReplicationJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
