package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAttachedMedia invokes the vod.DeleteAttachedMedia API synchronously
// api document: https://help.aliyun.com/api/vod/deleteattachedmedia.html
func (client *Client) DeleteAttachedMedia(request *DeleteAttachedMediaRequest) (response *DeleteAttachedMediaResponse, err error) {
	response = CreateDeleteAttachedMediaResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAttachedMediaWithChan invokes the vod.DeleteAttachedMedia API asynchronously
// api document: https://help.aliyun.com/api/vod/deleteattachedmedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAttachedMediaWithChan(request *DeleteAttachedMediaRequest) (<-chan *DeleteAttachedMediaResponse, <-chan error) {
	responseChan := make(chan *DeleteAttachedMediaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAttachedMedia(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAttachedMediaWithCallback invokes the vod.DeleteAttachedMedia API asynchronously
// api document: https://help.aliyun.com/api/vod/deleteattachedmedia.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAttachedMediaWithCallback(request *DeleteAttachedMediaRequest, callback func(response *DeleteAttachedMediaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAttachedMediaResponse
		var err error
		defer close(result)
		response, err = client.DeleteAttachedMedia(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAttachedMediaRequest is the request struct for api DeleteAttachedMedia
type DeleteAttachedMediaRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	MediaIds             string           `position:"Query" name:"MediaIds"`
}

// DeleteAttachedMediaResponse is the response struct for api DeleteAttachedMedia
type DeleteAttachedMediaResponse struct {
	*responses.BaseResponse
	RequestId        string   `json:"RequestId" xml:"RequestId"`
	NonExistMediaIds []string `json:"NonExistMediaIds" xml:"NonExistMediaIds"`
}

// CreateDeleteAttachedMediaRequest creates a request to invoke DeleteAttachedMedia API
func CreateDeleteAttachedMediaRequest() (request *DeleteAttachedMediaRequest) {
	request = &DeleteAttachedMediaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DeleteAttachedMedia", "vod", "openAPI")
	return
}

// CreateDeleteAttachedMediaResponse creates a response to parse from DeleteAttachedMedia response
func CreateDeleteAttachedMediaResponse() (response *DeleteAttachedMediaResponse) {
	response = &DeleteAttachedMediaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
