package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteMessageCallback invokes the vod.DeleteMessageCallback API synchronously
// api document: https://help.aliyun.com/api/vod/deletemessagecallback.html
func (client *Client) DeleteMessageCallback(request *DeleteMessageCallbackRequest) (response *DeleteMessageCallbackResponse, err error) {
	response = CreateDeleteMessageCallbackResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteMessageCallbackWithChan invokes the vod.DeleteMessageCallback API asynchronously
// api document: https://help.aliyun.com/api/vod/deletemessagecallback.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMessageCallbackWithChan(request *DeleteMessageCallbackRequest) (<-chan *DeleteMessageCallbackResponse, <-chan error) {
	responseChan := make(chan *DeleteMessageCallbackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteMessageCallback(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteMessageCallbackWithCallback invokes the vod.DeleteMessageCallback API asynchronously
// api document: https://help.aliyun.com/api/vod/deletemessagecallback.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteMessageCallbackWithCallback(request *DeleteMessageCallbackRequest, callback func(response *DeleteMessageCallbackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteMessageCallbackResponse
		var err error
		defer close(result)
		response, err = client.DeleteMessageCallback(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteMessageCallbackRequest is the request struct for api DeleteMessageCallback
type DeleteMessageCallbackRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string           `position:"Query" name:"ResourceOwnerId"`
	ResourceRealOwnerId  requests.Integer `position:"Query" name:"ResourceRealOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
	AppId                string           `position:"Query" name:"AppId"`
}

// DeleteMessageCallbackResponse is the response struct for api DeleteMessageCallback
type DeleteMessageCallbackResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteMessageCallbackRequest creates a request to invoke DeleteMessageCallback API
func CreateDeleteMessageCallbackRequest() (request *DeleteMessageCallbackRequest) {
	request = &DeleteMessageCallbackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DeleteMessageCallback", "vod", "openAPI")
	return
}

// CreateDeleteMessageCallbackResponse creates a response to parse from DeleteMessageCallback response
func CreateDeleteMessageCallbackResponse() (response *DeleteMessageCallbackResponse) {
	response = &DeleteMessageCallbackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
