package vod

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVodDomainCertificateInfo invokes the vod.DescribeVodDomainCertificateInfo API synchronously
// api document: https://help.aliyun.com/api/vod/describevoddomaincertificateinfo.html
func (client *Client) DescribeVodDomainCertificateInfo(request *DescribeVodDomainCertificateInfoRequest) (response *DescribeVodDomainCertificateInfoResponse, err error) {
	response = CreateDescribeVodDomainCertificateInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVodDomainCertificateInfoWithChan invokes the vod.DescribeVodDomainCertificateInfo API asynchronously
// api document: https://help.aliyun.com/api/vod/describevoddomaincertificateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVodDomainCertificateInfoWithChan(request *DescribeVodDomainCertificateInfoRequest) (<-chan *DescribeVodDomainCertificateInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeVodDomainCertificateInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVodDomainCertificateInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVodDomainCertificateInfoWithCallback invokes the vod.DescribeVodDomainCertificateInfo API asynchronously
// api document: https://help.aliyun.com/api/vod/describevoddomaincertificateinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVodDomainCertificateInfoWithCallback(request *DescribeVodDomainCertificateInfoRequest, callback func(response *DescribeVodDomainCertificateInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVodDomainCertificateInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeVodDomainCertificateInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVodDomainCertificateInfoRequest is the request struct for api DescribeVodDomainCertificateInfo
type DescribeVodDomainCertificateInfoRequest struct {
	*requests.RpcRequest
	DomainName string           `position:"Query" name:"DomainName"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeVodDomainCertificateInfoResponse is the response struct for api DescribeVodDomainCertificateInfo
type DescribeVodDomainCertificateInfoResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	CertInfos CertInfos `json:"CertInfos" xml:"CertInfos"`
}

// CreateDescribeVodDomainCertificateInfoRequest creates a request to invoke DescribeVodDomainCertificateInfo API
func CreateDescribeVodDomainCertificateInfoRequest() (request *DescribeVodDomainCertificateInfoRequest) {
	request = &DescribeVodDomainCertificateInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("vod", "2017-03-21", "DescribeVodDomainCertificateInfo", "vod", "openAPI")
	return
}

// CreateDescribeVodDomainCertificateInfoResponse creates a response to parse from DescribeVodDomainCertificateInfo response
func CreateDescribeVodDomainCertificateInfoResponse() (response *DescribeVodDomainCertificateInfoResponse) {
	response = &DescribeVodDomainCertificateInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
