package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AssociatePhysicalConnectionToVirtualBorderRouter invokes the vpc.AssociatePhysicalConnectionToVirtualBorderRouter API synchronously
// api document: https://help.aliyun.com/api/vpc/associatephysicalconnectiontovirtualborderrouter.html
func (client *Client) AssociatePhysicalConnectionToVirtualBorderRouter(request *AssociatePhysicalConnectionToVirtualBorderRouterRequest) (response *AssociatePhysicalConnectionToVirtualBorderRouterResponse, err error) {
	response = CreateAssociatePhysicalConnectionToVirtualBorderRouterResponse()
	err = client.DoAction(request, response)
	return
}

// AssociatePhysicalConnectionToVirtualBorderRouterWithChan invokes the vpc.AssociatePhysicalConnectionToVirtualBorderRouter API asynchronously
// api document: https://help.aliyun.com/api/vpc/associatephysicalconnectiontovirtualborderrouter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AssociatePhysicalConnectionToVirtualBorderRouterWithChan(request *AssociatePhysicalConnectionToVirtualBorderRouterRequest) (<-chan *AssociatePhysicalConnectionToVirtualBorderRouterResponse, <-chan error) {
	responseChan := make(chan *AssociatePhysicalConnectionToVirtualBorderRouterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AssociatePhysicalConnectionToVirtualBorderRouter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AssociatePhysicalConnectionToVirtualBorderRouterWithCallback invokes the vpc.AssociatePhysicalConnectionToVirtualBorderRouter API asynchronously
// api document: https://help.aliyun.com/api/vpc/associatephysicalconnectiontovirtualborderrouter.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) AssociatePhysicalConnectionToVirtualBorderRouterWithCallback(request *AssociatePhysicalConnectionToVirtualBorderRouterRequest, callback func(response *AssociatePhysicalConnectionToVirtualBorderRouterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AssociatePhysicalConnectionToVirtualBorderRouterResponse
		var err error
		defer close(result)
		response, err = client.AssociatePhysicalConnectionToVirtualBorderRouter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AssociatePhysicalConnectionToVirtualBorderRouterRequest is the request struct for api AssociatePhysicalConnectionToVirtualBorderRouter
type AssociatePhysicalConnectionToVirtualBorderRouterRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CircuitCode          string           `position:"Query" name:"CircuitCode"`
	VlanId               string           `position:"Query" name:"VlanId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	VbrId                string           `position:"Query" name:"VbrId"`
	PeerGatewayIp        string           `position:"Query" name:"PeerGatewayIp"`
	PeeringSubnetMask    string           `position:"Query" name:"PeeringSubnetMask"`
	LocalGatewayIp       string           `position:"Query" name:"LocalGatewayIp"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PhysicalConnectionId string           `position:"Query" name:"PhysicalConnectionId"`
}

// AssociatePhysicalConnectionToVirtualBorderRouterResponse is the response struct for api AssociatePhysicalConnectionToVirtualBorderRouter
type AssociatePhysicalConnectionToVirtualBorderRouterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAssociatePhysicalConnectionToVirtualBorderRouterRequest creates a request to invoke AssociatePhysicalConnectionToVirtualBorderRouter API
func CreateAssociatePhysicalConnectionToVirtualBorderRouterRequest() (request *AssociatePhysicalConnectionToVirtualBorderRouterRequest) {
	request = &AssociatePhysicalConnectionToVirtualBorderRouterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "AssociatePhysicalConnectionToVirtualBorderRouter", "vpc", "openAPI")
	return
}

// CreateAssociatePhysicalConnectionToVirtualBorderRouterResponse creates a response to parse from AssociatePhysicalConnectionToVirtualBorderRouter response
func CreateAssociatePhysicalConnectionToVirtualBorderRouterResponse() (response *AssociatePhysicalConnectionToVirtualBorderRouterResponse) {
	response = &AssociatePhysicalConnectionToVirtualBorderRouterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
