package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBandwidthPackage invokes the vpc.CreateBandwidthPackage API synchronously
// api document: https://help.aliyun.com/api/vpc/createbandwidthpackage.html
func (client *Client) CreateBandwidthPackage(request *CreateBandwidthPackageRequest) (response *CreateBandwidthPackageResponse, err error) {
	response = CreateCreateBandwidthPackageResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBandwidthPackageWithChan invokes the vpc.CreateBandwidthPackage API asynchronously
// api document: https://help.aliyun.com/api/vpc/createbandwidthpackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBandwidthPackageWithChan(request *CreateBandwidthPackageRequest) (<-chan *CreateBandwidthPackageResponse, <-chan error) {
	responseChan := make(chan *CreateBandwidthPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBandwidthPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBandwidthPackageWithCallback invokes the vpc.CreateBandwidthPackage API asynchronously
// api document: https://help.aliyun.com/api/vpc/createbandwidthpackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateBandwidthPackageWithCallback(request *CreateBandwidthPackageRequest, callback func(response *CreateBandwidthPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBandwidthPackageResponse
		var err error
		defer close(result)
		response, err = client.CreateBandwidthPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBandwidthPackageRequest is the request struct for api CreateBandwidthPackage
type CreateBandwidthPackageRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ISP                  string           `position:"Query" name:"ISP"`
	Description          string           `position:"Query" name:"Description"`
	Zone                 string           `position:"Query" name:"Zone"`
	NatGatewayId         string           `position:"Query" name:"NatGatewayId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth            requests.Integer `position:"Query" name:"Bandwidth"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InternetChargeType   string           `position:"Query" name:"InternetChargeType"`
	Name                 string           `position:"Query" name:"Name"`
	IpCount              requests.Integer `position:"Query" name:"IpCount"`
}

// CreateBandwidthPackageResponse is the response struct for api CreateBandwidthPackage
type CreateBandwidthPackageResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	BandwidthPackageId string `json:"BandwidthPackageId" xml:"BandwidthPackageId"`
}

// CreateCreateBandwidthPackageRequest creates a request to invoke CreateBandwidthPackage API
func CreateCreateBandwidthPackageRequest() (request *CreateBandwidthPackageRequest) {
	request = &CreateBandwidthPackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "CreateBandwidthPackage", "vpc", "openAPI")
	return
}

// CreateCreateBandwidthPackageResponse creates a response to parse from CreateBandwidthPackage response
func CreateCreateBandwidthPackageResponse() (response *CreateBandwidthPackageResponse) {
	response = &CreateBandwidthPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
