package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCommonBandwidthPackageIpBandwidth invokes the vpc.ModifyCommonBandwidthPackageIpBandwidth API synchronously
// api document: https://help.aliyun.com/api/vpc/modifycommonbandwidthpackageipbandwidth.html
func (client *Client) ModifyCommonBandwidthPackageIpBandwidth(request *ModifyCommonBandwidthPackageIpBandwidthRequest) (response *ModifyCommonBandwidthPackageIpBandwidthResponse, err error) {
	response = CreateModifyCommonBandwidthPackageIpBandwidthResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCommonBandwidthPackageIpBandwidthWithChan invokes the vpc.ModifyCommonBandwidthPackageIpBandwidth API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifycommonbandwidthpackageipbandwidth.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCommonBandwidthPackageIpBandwidthWithChan(request *ModifyCommonBandwidthPackageIpBandwidthRequest) (<-chan *ModifyCommonBandwidthPackageIpBandwidthResponse, <-chan error) {
	responseChan := make(chan *ModifyCommonBandwidthPackageIpBandwidthResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCommonBandwidthPackageIpBandwidth(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCommonBandwidthPackageIpBandwidthWithCallback invokes the vpc.ModifyCommonBandwidthPackageIpBandwidth API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifycommonbandwidthpackageipbandwidth.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyCommonBandwidthPackageIpBandwidthWithCallback(request *ModifyCommonBandwidthPackageIpBandwidthRequest, callback func(response *ModifyCommonBandwidthPackageIpBandwidthResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCommonBandwidthPackageIpBandwidthResponse
		var err error
		defer close(result)
		response, err = client.ModifyCommonBandwidthPackageIpBandwidth(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCommonBandwidthPackageIpBandwidthRequest is the request struct for api ModifyCommonBandwidthPackageIpBandwidth
type ModifyCommonBandwidthPackageIpBandwidthRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	BandwidthPackageId   string           `position:"Query" name:"BandwidthPackageId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	Bandwidth            string           `position:"Query" name:"Bandwidth"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EipId                string           `position:"Query" name:"EipId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyCommonBandwidthPackageIpBandwidthResponse is the response struct for api ModifyCommonBandwidthPackageIpBandwidth
type ModifyCommonBandwidthPackageIpBandwidthResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCommonBandwidthPackageIpBandwidthRequest creates a request to invoke ModifyCommonBandwidthPackageIpBandwidth API
func CreateModifyCommonBandwidthPackageIpBandwidthRequest() (request *ModifyCommonBandwidthPackageIpBandwidthRequest) {
	request = &ModifyCommonBandwidthPackageIpBandwidthRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyCommonBandwidthPackageIpBandwidth", "vpc", "openAPI")
	return
}

// CreateModifyCommonBandwidthPackageIpBandwidthResponse creates a response to parse from ModifyCommonBandwidthPackageIpBandwidth response
func CreateModifyCommonBandwidthPackageIpBandwidthResponse() (response *ModifyCommonBandwidthPackageIpBandwidthResponse) {
	response = &ModifyCommonBandwidthPackageIpBandwidthResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
