package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyGlobalAccelerationInstanceAttributes invokes the vpc.ModifyGlobalAccelerationInstanceAttributes API synchronously
// api document: https://help.aliyun.com/api/vpc/modifyglobalaccelerationinstanceattributes.html
func (client *Client) ModifyGlobalAccelerationInstanceAttributes(request *ModifyGlobalAccelerationInstanceAttributesRequest) (response *ModifyGlobalAccelerationInstanceAttributesResponse, err error) {
	response = CreateModifyGlobalAccelerationInstanceAttributesResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyGlobalAccelerationInstanceAttributesWithChan invokes the vpc.ModifyGlobalAccelerationInstanceAttributes API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyglobalaccelerationinstanceattributes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyGlobalAccelerationInstanceAttributesWithChan(request *ModifyGlobalAccelerationInstanceAttributesRequest) (<-chan *ModifyGlobalAccelerationInstanceAttributesResponse, <-chan error) {
	responseChan := make(chan *ModifyGlobalAccelerationInstanceAttributesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyGlobalAccelerationInstanceAttributes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyGlobalAccelerationInstanceAttributesWithCallback invokes the vpc.ModifyGlobalAccelerationInstanceAttributes API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyglobalaccelerationinstanceattributes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyGlobalAccelerationInstanceAttributesWithCallback(request *ModifyGlobalAccelerationInstanceAttributesRequest, callback func(response *ModifyGlobalAccelerationInstanceAttributesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyGlobalAccelerationInstanceAttributesResponse
		var err error
		defer close(result)
		response, err = client.ModifyGlobalAccelerationInstanceAttributes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyGlobalAccelerationInstanceAttributesRequest is the request struct for api ModifyGlobalAccelerationInstanceAttributes
type ModifyGlobalAccelerationInstanceAttributesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId              requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Description                  string           `position:"Query" name:"Description"`
	GlobalAccelerationInstanceId string           `position:"Query" name:"GlobalAccelerationInstanceId"`
	ResourceOwnerAccount         string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                 string           `position:"Query" name:"OwnerAccount"`
	OwnerId                      requests.Integer `position:"Query" name:"OwnerId"`
	Name                         string           `position:"Query" name:"Name"`
}

// ModifyGlobalAccelerationInstanceAttributesResponse is the response struct for api ModifyGlobalAccelerationInstanceAttributes
type ModifyGlobalAccelerationInstanceAttributesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyGlobalAccelerationInstanceAttributesRequest creates a request to invoke ModifyGlobalAccelerationInstanceAttributes API
func CreateModifyGlobalAccelerationInstanceAttributesRequest() (request *ModifyGlobalAccelerationInstanceAttributesRequest) {
	request = &ModifyGlobalAccelerationInstanceAttributesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyGlobalAccelerationInstanceAttributes", "vpc", "openAPI")
	return
}

// CreateModifyGlobalAccelerationInstanceAttributesResponse creates a response to parse from ModifyGlobalAccelerationInstanceAttributes response
func CreateModifyGlobalAccelerationInstanceAttributesResponse() (response *ModifyGlobalAccelerationInstanceAttributesResponse) {
	response = &ModifyGlobalAccelerationInstanceAttributesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
