package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyIPv6TranslatorAttribute invokes the vpc.ModifyIPv6TranslatorAttribute API synchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6translatorattribute.html
func (client *Client) ModifyIPv6TranslatorAttribute(request *ModifyIPv6TranslatorAttributeRequest) (response *ModifyIPv6TranslatorAttributeResponse, err error) {
	response = CreateModifyIPv6TranslatorAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyIPv6TranslatorAttributeWithChan invokes the vpc.ModifyIPv6TranslatorAttribute API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6translatorattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIPv6TranslatorAttributeWithChan(request *ModifyIPv6TranslatorAttributeRequest) (<-chan *ModifyIPv6TranslatorAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyIPv6TranslatorAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyIPv6TranslatorAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyIPv6TranslatorAttributeWithCallback invokes the vpc.ModifyIPv6TranslatorAttribute API asynchronously
// api document: https://help.aliyun.com/api/vpc/modifyipv6translatorattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyIPv6TranslatorAttributeWithCallback(request *ModifyIPv6TranslatorAttributeRequest, callback func(response *ModifyIPv6TranslatorAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyIPv6TranslatorAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyIPv6TranslatorAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyIPv6TranslatorAttributeRequest is the request struct for api ModifyIPv6TranslatorAttribute
type ModifyIPv6TranslatorAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	Description          string           `position:"Query" name:"Description"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Name                 string           `position:"Query" name:"Name"`
	Ipv6TranslatorId     string           `position:"Query" name:"Ipv6TranslatorId"`
}

// ModifyIPv6TranslatorAttributeResponse is the response struct for api ModifyIPv6TranslatorAttribute
type ModifyIPv6TranslatorAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyIPv6TranslatorAttributeRequest creates a request to invoke ModifyIPv6TranslatorAttribute API
func CreateModifyIPv6TranslatorAttributeRequest() (request *ModifyIPv6TranslatorAttributeRequest) {
	request = &ModifyIPv6TranslatorAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ModifyIPv6TranslatorAttribute", "vpc", "openAPI")
	return
}

// CreateModifyIPv6TranslatorAttributeResponse creates a response to parse from ModifyIPv6TranslatorAttribute response
func CreateModifyIPv6TranslatorAttributeResponse() (response *ModifyIPv6TranslatorAttributeResponse) {
	response = &ModifyIPv6TranslatorAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
