package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PublishVpnRouteEntry invokes the vpc.PublishVpnRouteEntry API synchronously
// api document: https://help.aliyun.com/api/vpc/publishvpnrouteentry.html
func (client *Client) PublishVpnRouteEntry(request *PublishVpnRouteEntryRequest) (response *PublishVpnRouteEntryResponse, err error) {
	response = CreatePublishVpnRouteEntryResponse()
	err = client.DoAction(request, response)
	return
}

// PublishVpnRouteEntryWithChan invokes the vpc.PublishVpnRouteEntry API asynchronously
// api document: https://help.aliyun.com/api/vpc/publishvpnrouteentry.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PublishVpnRouteEntryWithChan(request *PublishVpnRouteEntryRequest) (<-chan *PublishVpnRouteEntryResponse, <-chan error) {
	responseChan := make(chan *PublishVpnRouteEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PublishVpnRouteEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PublishVpnRouteEntryWithCallback invokes the vpc.PublishVpnRouteEntry API asynchronously
// api document: https://help.aliyun.com/api/vpc/publishvpnrouteentry.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PublishVpnRouteEntryWithCallback(request *PublishVpnRouteEntryRequest, callback func(response *PublishVpnRouteEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PublishVpnRouteEntryResponse
		var err error
		defer close(result)
		response, err = client.PublishVpnRouteEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PublishVpnRouteEntryRequest is the request struct for api PublishVpnRouteEntry
type PublishVpnRouteEntryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	RouteType            string           `position:"Query" name:"RouteType"`
	PublishVpc           requests.Boolean `position:"Query" name:"PublishVpc"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	VpnGatewayId         string           `position:"Query" name:"VpnGatewayId"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	RouteDest            string           `position:"Query" name:"RouteDest"`
	NextHop              string           `position:"Query" name:"NextHop"`
}

// PublishVpnRouteEntryResponse is the response struct for api PublishVpnRouteEntry
type PublishVpnRouteEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePublishVpnRouteEntryRequest creates a request to invoke PublishVpnRouteEntry API
func CreatePublishVpnRouteEntryRequest() (request *PublishVpnRouteEntryRequest) {
	request = &PublishVpnRouteEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "PublishVpnRouteEntry", "vpc", "openAPI")
	return
}

// CreatePublishVpnRouteEntryResponse creates a response to parse from PublishVpnRouteEntry response
func CreatePublishVpnRouteEntryResponse() (response *PublishVpnRouteEntryResponse) {
	response = &PublishVpnRouteEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
