// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package acmpca

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificateRequest
type IssueCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that was returned when you called CreateCertificateAuthority.
	// This must be of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012
	//
	// CertificateAuthorityArn is a required field
	CertificateAuthorityArn *string `min:"5" type:"string" required:"true"`

	// The certificate signing request (CSR) for the certificate you want to issue.
	// You can use the following OpenSSL command to create the CSR and a 2048 bit
	// RSA private key.
	//
	// openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem
	// -out csr/test_cert_.csr
	//
	// If you have a configuration file, you can use the following OpenSSL command.
	// The usr_cert block in the configuration file contains your X509 version 3
	// extensions.
	//
	// openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048
	// -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr
	//
	// Csr is automatically base64 encoded/decoded by the SDK.
	//
	// Csr is a required field
	Csr []byte `min:"1" type:"blob" required:"true"`

	// Custom string that can be used to distinguish between calls to the IssueCertificate
	// operation. Idempotency tokens time out after one hour. Therefore, if you
	// call IssueCertificate multiple times with the same idempotency token within
	// 5 minutes, ACM PCA recognizes that you are requesting only one certificate
	// and will issue only one. If you change the idempotency token for each call,
	// PCA recognizes that you are requesting multiple certificates.
	IdempotencyToken *string `min:"1" type:"string"`

	// The name of the algorithm that will be used to sign the certificate to be
	// issued.
	//
	// SigningAlgorithm is a required field
	SigningAlgorithm SigningAlgorithm `type:"string" required:"true" enum:"true"`

	// The type of the validity period.
	//
	// Validity is a required field
	Validity *Validity `type:"structure" required:"true"`
}

// String returns the string representation
func (s IssueCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IssueCertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IssueCertificateInput"}

	if s.CertificateAuthorityArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateAuthorityArn"))
	}
	if s.CertificateAuthorityArn != nil && len(*s.CertificateAuthorityArn) < 5 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateAuthorityArn", 5))
	}

	if s.Csr == nil {
		invalidParams.Add(aws.NewErrParamRequired("Csr"))
	}
	if s.Csr != nil && len(s.Csr) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Csr", 1))
	}
	if s.IdempotencyToken != nil && len(*s.IdempotencyToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("IdempotencyToken", 1))
	}
	if len(s.SigningAlgorithm) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("SigningAlgorithm"))
	}

	if s.Validity == nil {
		invalidParams.Add(aws.NewErrParamRequired("Validity"))
	}
	if s.Validity != nil {
		if err := s.Validity.Validate(); err != nil {
			invalidParams.AddNested("Validity", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificateResponse
type IssueCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the issued certificate and the certificate
	// serial number. This is of the form:
	//
	// arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012/certificate/286535153982981100925020015808220737245
	CertificateArn *string `min:"5" type:"string"`
}

// String returns the string representation
func (s IssueCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

const opIssueCertificate = "IssueCertificate"

// IssueCertificateRequest returns a request value for making API operation for
// AWS Certificate Manager Private Certificate Authority.
//
// Uses your private certificate authority (CA) to issue a client certificate.
// This operation returns the Amazon Resource Name (ARN) of the certificate.
// You can retrieve the certificate by calling the GetCertificate operation
// and specifying the ARN.
//
// You cannot use the ACM ListCertificateAuthorities operation to retrieve the
// ARNs of the certificates that you issue by using ACM PCA.
//
//    // Example sending a request using IssueCertificateRequest.
//    req := client.IssueCertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/acm-pca-2017-08-22/IssueCertificate
func (c *Client) IssueCertificateRequest(input *IssueCertificateInput) IssueCertificateRequest {
	op := &aws.Operation{
		Name:       opIssueCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IssueCertificateInput{}
	}

	req := c.newRequest(op, input, &IssueCertificateOutput{})
	return IssueCertificateRequest{Request: req, Input: input, Copy: c.IssueCertificateRequest}
}

// IssueCertificateRequest is the request type for the
// IssueCertificate API operation.
type IssueCertificateRequest struct {
	*aws.Request
	Input *IssueCertificateInput
	Copy  func(*IssueCertificateInput) IssueCertificateRequest
}

// Send marshals and sends the IssueCertificate API request.
func (r IssueCertificateRequest) Send(ctx context.Context) (*IssueCertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &IssueCertificateResponse{
		IssueCertificateOutput: r.Request.Data.(*IssueCertificateOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// IssueCertificateResponse is the response type for the
// IssueCertificate API operation.
type IssueCertificateResponse struct {
	*IssueCertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// IssueCertificate request.
func (r *IssueCertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
