// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettingsRequest
type GetUserSettingsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime account ID.
	//
	// AccountId is a required field
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The user ID.
	//
	// UserId is a required field
	UserId *string `location:"uri" locationName:"userId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserSettingsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetUserSettingsInput"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.UserId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUserSettingsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserId != nil {
		v := *s.UserId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "userId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettingsResponse
type GetUserSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The user settings.
	UserSettings *UserSettings `type:"structure"`
}

// String returns the string representation
func (s GetUserSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUserSettingsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.UserSettings != nil {
		v := s.UserSettings

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "UserSettings", v, metadata)
	}
	return nil
}

const opGetUserSettings = "GetUserSettings"

// GetUserSettingsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Retrieves settings for the specified user ID, such as any associated phone
// number settings.
//
//    // Example sending a request using GetUserSettingsRequest.
//    req := client.GetUserSettingsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/GetUserSettings
func (c *Client) GetUserSettingsRequest(input *GetUserSettingsInput) GetUserSettingsRequest {
	op := &aws.Operation{
		Name:       opGetUserSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/accounts/{accountId}/users/{userId}/settings",
	}

	if input == nil {
		input = &GetUserSettingsInput{}
	}

	req := c.newRequest(op, input, &GetUserSettingsOutput{})
	return GetUserSettingsRequest{Request: req, Input: input, Copy: c.GetUserSettingsRequest}
}

// GetUserSettingsRequest is the request type for the
// GetUserSettings API operation.
type GetUserSettingsRequest struct {
	*aws.Request
	Input *GetUserSettingsInput
	Copy  func(*GetUserSettingsInput) GetUserSettingsRequest
}

// Send marshals and sends the GetUserSettings API request.
func (r GetUserSettingsRequest) Send(ctx context.Context) (*GetUserSettingsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUserSettingsResponse{
		GetUserSettingsOutput: r.Request.Data.(*GetUserSettingsOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetUserSettingsResponse is the response type for the
// GetUserSettings API operation.
type GetUserSettingsResponse struct {
	*GetUserSettingsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUserSettings request.
func (r *GetUserSettingsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
