// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudsearch

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Container for the parameters to the DefineAnalysisScheme operation. Specifies
// the name of the domain you want to update and the analysis scheme configuration.
type DefineAnalysisSchemeInput struct {
	_ struct{} `type:"structure"`

	// Configuration information for an analysis scheme. Each analysis scheme has
	// a unique name and specifies the language of the text to be processed. The
	// following options can be configured for an analysis scheme: Synonyms, Stopwords,
	// StemmingDictionary, JapaneseTokenizationDictionary and AlgorithmicStemming.
	//
	// AnalysisScheme is a required field
	AnalysisScheme *AnalysisScheme `type:"structure" required:"true"`

	// A string that represents the name of a domain. Domain names are unique across
	// the domains owned by an account within an AWS region. Domain names start
	// with a letter or number and can contain the following characters: a-z (lowercase),
	// 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DefineAnalysisSchemeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DefineAnalysisSchemeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DefineAnalysisSchemeInput"}

	if s.AnalysisScheme == nil {
		invalidParams.Add(aws.NewErrParamRequired("AnalysisScheme"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}
	if s.AnalysisScheme != nil {
		if err := s.AnalysisScheme.Validate(); err != nil {
			invalidParams.AddNested("AnalysisScheme", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DefineAnalysisScheme request. Contains the status of the
// newly-configured analysis scheme.
type DefineAnalysisSchemeOutput struct {
	_ struct{} `type:"structure"`

	// The status and configuration of an AnalysisScheme.
	//
	// AnalysisScheme is a required field
	AnalysisScheme *AnalysisSchemeStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DefineAnalysisSchemeOutput) String() string {
	return awsutil.Prettify(s)
}

const opDefineAnalysisScheme = "DefineAnalysisScheme"

// DefineAnalysisSchemeRequest returns a request value for making API operation for
// Amazon CloudSearch.
//
// Configures an analysis scheme that can be applied to a text or text-array
// field to define language-specific text processing options. For more information,
// see Configuring Analysis Schemes (http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html)
// in the Amazon CloudSearch Developer Guide.
//
//    // Example sending a request using DefineAnalysisSchemeRequest.
//    req := client.DefineAnalysisSchemeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DefineAnalysisSchemeRequest(input *DefineAnalysisSchemeInput) DefineAnalysisSchemeRequest {
	op := &aws.Operation{
		Name:       opDefineAnalysisScheme,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DefineAnalysisSchemeInput{}
	}

	req := c.newRequest(op, input, &DefineAnalysisSchemeOutput{})
	return DefineAnalysisSchemeRequest{Request: req, Input: input, Copy: c.DefineAnalysisSchemeRequest}
}

// DefineAnalysisSchemeRequest is the request type for the
// DefineAnalysisScheme API operation.
type DefineAnalysisSchemeRequest struct {
	*aws.Request
	Input *DefineAnalysisSchemeInput
	Copy  func(*DefineAnalysisSchemeInput) DefineAnalysisSchemeRequest
}

// Send marshals and sends the DefineAnalysisScheme API request.
func (r DefineAnalysisSchemeRequest) Send(ctx context.Context) (*DefineAnalysisSchemeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DefineAnalysisSchemeResponse{
		DefineAnalysisSchemeOutput: r.Request.Data.(*DefineAnalysisSchemeOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DefineAnalysisSchemeResponse is the response type for the
// DefineAnalysisScheme API operation.
type DefineAnalysisSchemeResponse struct {
	*DefineAnalysisSchemeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DefineAnalysisScheme request.
func (r *DefineAnalysisSchemeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
