// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codedeploy

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of an UpdateDeploymentGroup operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroupInput
type UpdateDeploymentGroupInput struct {
	_ struct{} `type:"structure"`

	// Information to add or change about Amazon CloudWatch alarms when the deployment
	// group is updated.
	AlarmConfiguration *AlarmConfiguration `locationName:"alarmConfiguration" type:"structure"`

	// The application name that corresponds to the deployment group to update.
	//
	// ApplicationName is a required field
	ApplicationName *string `locationName:"applicationName" min:"1" type:"string" required:"true"`

	// Information for an automatic rollback configuration that is added or changed
	// when a deployment group is updated.
	AutoRollbackConfiguration *AutoRollbackConfiguration `locationName:"autoRollbackConfiguration" type:"structure"`

	// The replacement list of Auto Scaling groups to be included in the deployment
	// group, if you want to change them. To keep the Auto Scaling groups, enter
	// their names. To remove Auto Scaling groups, do not enter any Auto Scaling
	// group names.
	AutoScalingGroups []string `locationName:"autoScalingGroups" type:"list"`

	// Information about blue/green deployment options for a deployment group.
	BlueGreenDeploymentConfiguration *BlueGreenDeploymentConfiguration `locationName:"blueGreenDeploymentConfiguration" type:"structure"`

	// The current name of the deployment group.
	//
	// CurrentDeploymentGroupName is a required field
	CurrentDeploymentGroupName *string `locationName:"currentDeploymentGroupName" min:"1" type:"string" required:"true"`

	// The replacement deployment configuration name to use, if you want to change
	// it.
	DeploymentConfigName *string `locationName:"deploymentConfigName" min:"1" type:"string"`

	// Information about the type of deployment, either in-place or blue/green,
	// you want to run and whether to route deployment traffic behind a load balancer.
	DeploymentStyle *DeploymentStyle `locationName:"deploymentStyle" type:"structure"`

	// The replacement set of Amazon EC2 tags on which to filter, if you want to
	// change them. To keep the existing tags, enter their names. To remove tags,
	// do not enter any tag names.
	Ec2TagFilters []EC2TagFilter `locationName:"ec2TagFilters" type:"list"`

	// Information about groups of tags applied to on-premises instances. The deployment
	// group includes only EC2 instances identified by all the tag groups.
	Ec2TagSet *EC2TagSet `locationName:"ec2TagSet" type:"structure"`

	// The target Amazon ECS services in the deployment group. This applies only
	// to deployment groups that use the Amazon ECS compute platform. A target Amazon
	// ECS service is specified as an Amazon ECS cluster and service name pair using
	// the format <clustername>:<servicename>.
	EcsServices []ECSService `locationName:"ecsServices" type:"list"`

	// Information about the load balancer used in a deployment.
	LoadBalancerInfo *LoadBalancerInfo `locationName:"loadBalancerInfo" type:"structure"`

	// The new name of the deployment group, if you want to change it.
	NewDeploymentGroupName *string `locationName:"newDeploymentGroupName" min:"1" type:"string"`

	// The replacement set of on-premises instance tags on which to filter, if you
	// want to change them. To keep the existing tags, enter their names. To remove
	// tags, do not enter any tag names.
	OnPremisesInstanceTagFilters []TagFilter `locationName:"onPremisesInstanceTagFilters" type:"list"`

	// Information about an on-premises instance tag set. The deployment group includes
	// only on-premises instances identified by all the tag groups.
	OnPremisesTagSet *OnPremisesTagSet `locationName:"onPremisesTagSet" type:"structure"`

	// A replacement ARN for the service role, if you want to change it.
	ServiceRoleArn *string `locationName:"serviceRoleArn" type:"string"`

	// Information about triggers to change when the deployment group is updated.
	// For examples, see Modify Triggers in an AWS CodeDeploy Deployment Group (https://docs.aws.amazon.com/codedeploy/latest/userguide/how-to-notify-edit.html)
	// in the AWS CodeDeploy User Guide.
	TriggerConfigurations []TriggerConfig `locationName:"triggerConfigurations" type:"list"`
}

// String returns the string representation
func (s UpdateDeploymentGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeploymentGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDeploymentGroupInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.CurrentDeploymentGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CurrentDeploymentGroupName"))
	}
	if s.CurrentDeploymentGroupName != nil && len(*s.CurrentDeploymentGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CurrentDeploymentGroupName", 1))
	}
	if s.DeploymentConfigName != nil && len(*s.DeploymentConfigName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DeploymentConfigName", 1))
	}
	if s.NewDeploymentGroupName != nil && len(*s.NewDeploymentGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NewDeploymentGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of an UpdateDeploymentGroup operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroupOutput
type UpdateDeploymentGroupOutput struct {
	_ struct{} `type:"structure"`

	// If the output contains no data, and the corresponding deployment group contained
	// at least one Auto Scaling group, AWS CodeDeploy successfully removed all
	// corresponding Auto Scaling lifecycle event hooks from the AWS account. If
	// the output contains data, AWS CodeDeploy could not remove some Auto Scaling
	// lifecycle event hooks from the AWS account.
	HooksNotCleanedUp []AutoScalingGroup `locationName:"hooksNotCleanedUp" type:"list"`
}

// String returns the string representation
func (s UpdateDeploymentGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDeploymentGroup = "UpdateDeploymentGroup"

// UpdateDeploymentGroupRequest returns a request value for making API operation for
// AWS CodeDeploy.
//
// Changes information about a deployment group.
//
//    // Example sending a request using UpdateDeploymentGroupRequest.
//    req := client.UpdateDeploymentGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codedeploy-2014-10-06/UpdateDeploymentGroup
func (c *Client) UpdateDeploymentGroupRequest(input *UpdateDeploymentGroupInput) UpdateDeploymentGroupRequest {
	op := &aws.Operation{
		Name:       opUpdateDeploymentGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDeploymentGroupInput{}
	}

	req := c.newRequest(op, input, &UpdateDeploymentGroupOutput{})
	return UpdateDeploymentGroupRequest{Request: req, Input: input, Copy: c.UpdateDeploymentGroupRequest}
}

// UpdateDeploymentGroupRequest is the request type for the
// UpdateDeploymentGroup API operation.
type UpdateDeploymentGroupRequest struct {
	*aws.Request
	Input *UpdateDeploymentGroupInput
	Copy  func(*UpdateDeploymentGroupInput) UpdateDeploymentGroupRequest
}

// Send marshals and sends the UpdateDeploymentGroup API request.
func (r UpdateDeploymentGroupRequest) Send(ctx context.Context) (*UpdateDeploymentGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDeploymentGroupResponse{
		UpdateDeploymentGroupOutput: r.Request.Data.(*UpdateDeploymentGroupOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDeploymentGroupResponse is the response type for the
// UpdateDeploymentGroup API operation.
type UpdateDeploymentGroupResponse struct {
	*UpdateDeploymentGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDeploymentGroup request.
func (r *UpdateDeploymentGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
