// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to get user attribute verification.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCodeRequest
type GetUserAttributeVerificationCodeInput struct {
	_ struct{} `type:"structure"`

	// The access token returned by the server response to get the user attribute
	// verification code.
	//
	// AccessToken is a required field
	AccessToken *string `type:"string" required:"true"`

	// The attribute name returned by the server response to get the user attribute
	// verification code.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetUserAttributeVerificationCodeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUserAttributeVerificationCodeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetUserAttributeVerificationCodeInput"}

	if s.AccessToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccessToken"))
	}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AttributeName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The verification code response returned by the server response to get the
// user attribute verification code.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCodeResponse
type GetUserAttributeVerificationCodeOutput struct {
	_ struct{} `type:"structure"`

	// The code delivery details returned by the server in response to the request
	// to get the user attribute verification code.
	CodeDeliveryDetails *CodeDeliveryDetailsType `type:"structure"`
}

// String returns the string representation
func (s GetUserAttributeVerificationCodeOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetUserAttributeVerificationCode = "GetUserAttributeVerificationCode"

// GetUserAttributeVerificationCodeRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Gets the user attribute verification code for the specified attribute name.
//
//    // Example sending a request using GetUserAttributeVerificationCodeRequest.
//    req := client.GetUserAttributeVerificationCodeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/GetUserAttributeVerificationCode
func (c *Client) GetUserAttributeVerificationCodeRequest(input *GetUserAttributeVerificationCodeInput) GetUserAttributeVerificationCodeRequest {
	op := &aws.Operation{
		Name:       opGetUserAttributeVerificationCode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUserAttributeVerificationCodeInput{}
	}

	req := c.newRequest(op, input, &GetUserAttributeVerificationCodeOutput{})
	req.Config.Credentials = aws.AnonymousCredentials
	return GetUserAttributeVerificationCodeRequest{Request: req, Input: input, Copy: c.GetUserAttributeVerificationCodeRequest}
}

// GetUserAttributeVerificationCodeRequest is the request type for the
// GetUserAttributeVerificationCode API operation.
type GetUserAttributeVerificationCodeRequest struct {
	*aws.Request
	Input *GetUserAttributeVerificationCodeInput
	Copy  func(*GetUserAttributeVerificationCodeInput) GetUserAttributeVerificationCodeRequest
}

// Send marshals and sends the GetUserAttributeVerificationCode API request.
func (r GetUserAttributeVerificationCodeRequest) Send(ctx context.Context) (*GetUserAttributeVerificationCodeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUserAttributeVerificationCodeResponse{
		GetUserAttributeVerificationCodeOutput: r.Request.Data.(*GetUserAttributeVerificationCodeOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetUserAttributeVerificationCodeResponse is the response type for the
// GetUserAttributeVerificationCode API operation.
type GetUserAttributeVerificationCodeResponse struct {
	*GetUserAttributeVerificationCodeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUserAttributeVerificationCode request.
func (r *GetUserAttributeVerificationCodeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
