// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRuleRequest
type PutConfigRuleInput struct {
	_ struct{} `type:"structure"`

	// The rule that you want to add to your account.
	//
	// ConfigRule is a required field
	ConfigRule *ConfigRule `type:"structure" required:"true"`

	Tags []Tag `type:"list"`
}

// String returns the string representation
func (s PutConfigRuleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutConfigRuleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutConfigRuleInput"}

	if s.ConfigRule == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigRule"))
	}
	if s.ConfigRule != nil {
		if err := s.ConfigRule.Validate(); err != nil {
			invalidParams.AddNested("ConfigRule", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRuleOutput
type PutConfigRuleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutConfigRuleOutput) String() string {
	return awsutil.Prettify(s)
}

const opPutConfigRule = "PutConfigRule"

// PutConfigRuleRequest returns a request value for making API operation for
// AWS Config.
//
// Adds or updates an AWS Config rule for evaluating whether your AWS resources
// comply with your desired configurations.
//
// You can use this action for custom AWS Config rules and AWS managed Config
// rules. A custom AWS Config rule is a rule that you develop and maintain.
// An AWS managed Config rule is a customizable, predefined rule that AWS Config
// provides.
//
// If you are adding a new custom AWS Config rule, you must first create the
// AWS Lambda function that the rule invokes to evaluate your resources. When
// you use the PutConfigRule action to add the rule to AWS Config, you must
// specify the Amazon Resource Name (ARN) that AWS Lambda assigns to the function.
// Specify the ARN for the SourceIdentifier key. This key is part of the Source
// object, which is part of the ConfigRule object.
//
// If you are adding an AWS managed Config rule, specify the rule's identifier
// for the SourceIdentifier key. To reference AWS managed Config rule identifiers,
// see About AWS Managed Config Rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
//
// For any new rule that you add, specify the ConfigRuleName in the ConfigRule
// object. Do not specify the ConfigRuleArn or the ConfigRuleId. These values
// are generated by AWS Config for new rules.
//
// If you are updating a rule that you added previously, you can specify the
// rule by ConfigRuleName, ConfigRuleId, or ConfigRuleArn in the ConfigRule
// data type that you use in this request.
//
// The maximum number of rules that AWS Config supports is 150.
//
// For information about requesting a rule limit increase, see AWS Config Limits
// (http://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html#limits_config)
// in the AWS General Reference Guide.
//
// For more information about developing and using AWS Config rules, see Evaluating
// AWS Resource Configurations with AWS Config (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the AWS Config Developer Guide.
//
//    // Example sending a request using PutConfigRuleRequest.
//    req := client.PutConfigRuleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PutConfigRule
func (c *Client) PutConfigRuleRequest(input *PutConfigRuleInput) PutConfigRuleRequest {
	op := &aws.Operation{
		Name:       opPutConfigRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutConfigRuleInput{}
	}

	req := c.newRequest(op, input, &PutConfigRuleOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return PutConfigRuleRequest{Request: req, Input: input, Copy: c.PutConfigRuleRequest}
}

// PutConfigRuleRequest is the request type for the
// PutConfigRule API operation.
type PutConfigRuleRequest struct {
	*aws.Request
	Input *PutConfigRuleInput
	Copy  func(*PutConfigRuleInput) PutConfigRuleRequest
}

// Send marshals and sends the PutConfigRule API request.
func (r PutConfigRuleRequest) Send(ctx context.Context) (*PutConfigRuleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutConfigRuleResponse{
		PutConfigRuleOutput: r.Request.Data.(*PutConfigRuleOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutConfigRuleResponse is the response type for the
// PutConfigRule API operation.
type PutConfigRuleResponse struct {
	*PutConfigRuleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutConfigRule request.
func (r *PutConfigRuleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
