// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJobRequest
type StopJobInput struct {
	_ struct{} `type:"structure"`

	// Represents the Amazon Resource Name (ARN) of the Device Farm job you wish
	// to stop.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`
}

// String returns the string representation
func (s StopJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StopJobInput"}

	if s.Arn == nil {
		invalidParams.Add(aws.NewErrParamRequired("Arn"))
	}
	if s.Arn != nil && len(*s.Arn) < 32 {
		invalidParams.Add(aws.NewErrParamMinLen("Arn", 32))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJobResult
type StopJobOutput struct {
	_ struct{} `type:"structure"`

	// The job that was stopped.
	Job *Job `locationName:"job" type:"structure"`
}

// String returns the string representation
func (s StopJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopJob = "StopJob"

// StopJobRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Initiates a stop request for the current job. AWS Device Farm will immediately
// stop the job on the device where tests have not started executing, and you
// will not be billed for this device. On the device where tests have started
// executing, Setup Suite and Teardown Suite tests will run to completion before
// stopping execution on the device. You will be billed for Setup, Teardown,
// and any tests that were in progress or already completed.
//
//    // Example sending a request using StopJobRequest.
//    req := client.StopJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/StopJob
func (c *Client) StopJobRequest(input *StopJobInput) StopJobRequest {
	op := &aws.Operation{
		Name:       opStopJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopJobInput{}
	}

	req := c.newRequest(op, input, &StopJobOutput{})
	return StopJobRequest{Request: req, Input: input, Copy: c.StopJobRequest}
}

// StopJobRequest is the request type for the
// StopJob API operation.
type StopJobRequest struct {
	*aws.Request
	Input *StopJobInput
	Copy  func(*StopJobInput) StopJobRequest
}

// Send marshals and sends the StopJob API request.
func (r StopJobRequest) Send(ctx context.Context) (*StopJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopJobResponse{
		StopJobOutput: r.Request.Data.(*StopJobOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopJobResponse is the response type for the
// StopJob API operation.
type StopJobResponse struct {
	*StopJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopJob request.
func (r *StopJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
