// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableTransitGatewayRouteTablePropagationRequest
type DisableTransitGatewayRouteTablePropagationInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the attachment.
	//
	// TransitGatewayAttachmentId is a required field
	TransitGatewayAttachmentId *string `type:"string" required:"true"`

	// The ID of the propagation route table.
	//
	// TransitGatewayRouteTableId is a required field
	TransitGatewayRouteTableId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisableTransitGatewayRouteTablePropagationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisableTransitGatewayRouteTablePropagationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisableTransitGatewayRouteTablePropagationInput"}

	if s.TransitGatewayAttachmentId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransitGatewayAttachmentId"))
	}

	if s.TransitGatewayRouteTableId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TransitGatewayRouteTableId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableTransitGatewayRouteTablePropagationResult
type DisableTransitGatewayRouteTablePropagationOutput struct {
	_ struct{} `type:"structure"`

	// Information about route propagation.
	Propagation *TransitGatewayPropagation `locationName:"propagation" type:"structure"`
}

// String returns the string representation
func (s DisableTransitGatewayRouteTablePropagationOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisableTransitGatewayRouteTablePropagation = "DisableTransitGatewayRouteTablePropagation"

// DisableTransitGatewayRouteTablePropagationRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Disables the specified resource attachment from propagating routes to the
// specified propagation route table.
//
//    // Example sending a request using DisableTransitGatewayRouteTablePropagationRequest.
//    req := client.DisableTransitGatewayRouteTablePropagationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DisableTransitGatewayRouteTablePropagation
func (c *Client) DisableTransitGatewayRouteTablePropagationRequest(input *DisableTransitGatewayRouteTablePropagationInput) DisableTransitGatewayRouteTablePropagationRequest {
	op := &aws.Operation{
		Name:       opDisableTransitGatewayRouteTablePropagation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableTransitGatewayRouteTablePropagationInput{}
	}

	req := c.newRequest(op, input, &DisableTransitGatewayRouteTablePropagationOutput{})
	return DisableTransitGatewayRouteTablePropagationRequest{Request: req, Input: input, Copy: c.DisableTransitGatewayRouteTablePropagationRequest}
}

// DisableTransitGatewayRouteTablePropagationRequest is the request type for the
// DisableTransitGatewayRouteTablePropagation API operation.
type DisableTransitGatewayRouteTablePropagationRequest struct {
	*aws.Request
	Input *DisableTransitGatewayRouteTablePropagationInput
	Copy  func(*DisableTransitGatewayRouteTablePropagationInput) DisableTransitGatewayRouteTablePropagationRequest
}

// Send marshals and sends the DisableTransitGatewayRouteTablePropagation API request.
func (r DisableTransitGatewayRouteTablePropagationRequest) Send(ctx context.Context) (*DisableTransitGatewayRouteTablePropagationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisableTransitGatewayRouteTablePropagationResponse{
		DisableTransitGatewayRouteTablePropagationOutput: r.Request.Data.(*DisableTransitGatewayRouteTablePropagationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisableTransitGatewayRouteTablePropagationResponse is the response type for the
// DisableTransitGatewayRouteTablePropagation API operation.
type DisableTransitGatewayRouteTablePropagationResponse struct {
	*DisableTransitGatewayRouteTablePropagationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisableTransitGatewayRouteTablePropagation request.
func (r *DisableTransitGatewayRouteTablePropagationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
