// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetEbsDefaultKmsKeyIdRequest
type ResetEbsDefaultKmsKeyIdInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`
}

// String returns the string representation
func (s ResetEbsDefaultKmsKeyIdInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetEbsDefaultKmsKeyIdResult
type ResetEbsDefaultKmsKeyIdOutput struct {
	_ struct{} `type:"structure"`

	// The full ARN of the default CMK that your account uses to encrypt an EBS
	// volume when no CMK is specified in the API call that creates the volume.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`
}

// String returns the string representation
func (s ResetEbsDefaultKmsKeyIdOutput) String() string {
	return awsutil.Prettify(s)
}

const opResetEbsDefaultKmsKeyId = "ResetEbsDefaultKmsKeyId"

// ResetEbsDefaultKmsKeyIdRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Resets the account's default customer master key (CMK) to the account's AWS-managed
// default CMK. This default CMK is used to encrypt EBS volumes when you have
// enabled EBS encryption by default without specifying a CMK in the API call.
// If you have not enabled encryption by default, then this CMK is used when
// you set the Encrypted parameter to true without specifying a custom CMK in
// the API call.
//
// Call this API if you have modified the default CMK that is used for encrypting
// your EBS volume using ModifyEbsDefaultKmsKeyId and you want to reset it to
// the AWS-managed default CMK. After resetting, you can continue to provide
// a CMK of your choice in the API call that creates the volume. However, if
// no CMK is specified, your account will encrypt the volume to the AWS-managed
// default CMK.
//
//    // Example sending a request using ResetEbsDefaultKmsKeyIdRequest.
//    req := client.ResetEbsDefaultKmsKeyIdRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetEbsDefaultKmsKeyId
func (c *Client) ResetEbsDefaultKmsKeyIdRequest(input *ResetEbsDefaultKmsKeyIdInput) ResetEbsDefaultKmsKeyIdRequest {
	op := &aws.Operation{
		Name:       opResetEbsDefaultKmsKeyId,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetEbsDefaultKmsKeyIdInput{}
	}

	req := c.newRequest(op, input, &ResetEbsDefaultKmsKeyIdOutput{})
	return ResetEbsDefaultKmsKeyIdRequest{Request: req, Input: input, Copy: c.ResetEbsDefaultKmsKeyIdRequest}
}

// ResetEbsDefaultKmsKeyIdRequest is the request type for the
// ResetEbsDefaultKmsKeyId API operation.
type ResetEbsDefaultKmsKeyIdRequest struct {
	*aws.Request
	Input *ResetEbsDefaultKmsKeyIdInput
	Copy  func(*ResetEbsDefaultKmsKeyIdInput) ResetEbsDefaultKmsKeyIdRequest
}

// Send marshals and sends the ResetEbsDefaultKmsKeyId API request.
func (r ResetEbsDefaultKmsKeyIdRequest) Send(ctx context.Context) (*ResetEbsDefaultKmsKeyIdResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResetEbsDefaultKmsKeyIdResponse{
		ResetEbsDefaultKmsKeyIdOutput: r.Request.Data.(*ResetEbsDefaultKmsKeyIdOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResetEbsDefaultKmsKeyIdResponse is the response type for the
// ResetEbsDefaultKmsKeyId API operation.
type ResetEbsDefaultKmsKeyIdResponse struct {
	*ResetEbsDefaultKmsKeyIdOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResetEbsDefaultKmsKeyId request.
func (r *ResetEbsDefaultKmsKeyIdResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
