// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/ec2query"
)

// Contains the parameters for ResetSnapshotAttribute.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetSnapshotAttributeRequest
type ResetSnapshotAttributeInput struct {
	_ struct{} `type:"structure"`

	// The attribute to reset. Currently, only the attribute for permission to create
	// volumes can be reset.
	//
	// Attribute is a required field
	Attribute SnapshotAttributeName `type:"string" required:"true" enum:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `locationName:"dryRun" type:"boolean"`

	// The ID of the snapshot.
	//
	// SnapshotId is a required field
	SnapshotId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ResetSnapshotAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResetSnapshotAttributeInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResetSnapshotAttributeInput"}
	if len(s.Attribute) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Attribute"))
	}

	if s.SnapshotId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SnapshotId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetSnapshotAttributeOutput
type ResetSnapshotAttributeOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ResetSnapshotAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

const opResetSnapshotAttribute = "ResetSnapshotAttribute"

// ResetSnapshotAttributeRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Resets permission settings for the specified snapshot.
//
// For more information about modifying snapshot permissions, see Sharing Snapshots
// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html)
// in the Amazon Elastic Compute Cloud User Guide.
//
//    // Example sending a request using ResetSnapshotAttributeRequest.
//    req := client.ResetSnapshotAttributeRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ResetSnapshotAttribute
func (c *Client) ResetSnapshotAttributeRequest(input *ResetSnapshotAttributeInput) ResetSnapshotAttributeRequest {
	op := &aws.Operation{
		Name:       opResetSnapshotAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResetSnapshotAttributeInput{}
	}

	req := c.newRequest(op, input, &ResetSnapshotAttributeOutput{})
	req.Handlers.Unmarshal.Remove(ec2query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ResetSnapshotAttributeRequest{Request: req, Input: input, Copy: c.ResetSnapshotAttributeRequest}
}

// ResetSnapshotAttributeRequest is the request type for the
// ResetSnapshotAttribute API operation.
type ResetSnapshotAttributeRequest struct {
	*aws.Request
	Input *ResetSnapshotAttributeInput
	Copy  func(*ResetSnapshotAttributeInput) ResetSnapshotAttributeRequest
}

// Send marshals and sends the ResetSnapshotAttribute API request.
func (r ResetSnapshotAttributeRequest) Send(ctx context.Context) (*ResetSnapshotAttributeResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ResetSnapshotAttributeResponse{
		ResetSnapshotAttributeOutput: r.Request.Data.(*ResetSnapshotAttributeOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ResetSnapshotAttributeResponse is the response type for the
// ResetSnapshotAttribute API operation.
type ResetSnapshotAttributeResponse struct {
	*ResetSnapshotAttributeOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ResetSnapshotAttribute request.
func (r *ResetSnapshotAttributeResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
