// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticache

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Represents the input of a DeleteCacheParameterGroup operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroupMessage
type DeleteCacheParameterGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cache parameter group to delete.
	//
	// The specified cache security group must not be associated with any clusters.
	//
	// CacheParameterGroupName is a required field
	CacheParameterGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCacheParameterGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCacheParameterGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCacheParameterGroupInput"}

	if s.CacheParameterGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("CacheParameterGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroupOutput
type DeleteCacheParameterGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCacheParameterGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteCacheParameterGroup = "DeleteCacheParameterGroup"

// DeleteCacheParameterGroupRequest returns a request value for making API operation for
// Amazon ElastiCache.
//
// Deletes the specified cache parameter group. You cannot delete a cache parameter
// group if it is associated with any cache clusters.
//
//    // Example sending a request using DeleteCacheParameterGroupRequest.
//    req := client.DeleteCacheParameterGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/DeleteCacheParameterGroup
func (c *Client) DeleteCacheParameterGroupRequest(input *DeleteCacheParameterGroupInput) DeleteCacheParameterGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteCacheParameterGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCacheParameterGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteCacheParameterGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteCacheParameterGroupRequest{Request: req, Input: input, Copy: c.DeleteCacheParameterGroupRequest}
}

// DeleteCacheParameterGroupRequest is the request type for the
// DeleteCacheParameterGroup API operation.
type DeleteCacheParameterGroupRequest struct {
	*aws.Request
	Input *DeleteCacheParameterGroupInput
	Copy  func(*DeleteCacheParameterGroupInput) DeleteCacheParameterGroupRequest
}

// Send marshals and sends the DeleteCacheParameterGroup API request.
func (r DeleteCacheParameterGroupRequest) Send(ctx context.Context) (*DeleteCacheParameterGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCacheParameterGroupResponse{
		DeleteCacheParameterGroupOutput: r.Request.Data.(*DeleteCacheParameterGroupOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCacheParameterGroupResponse is the response type for the
// DeleteCacheParameterGroup API operation.
type DeleteCacheParameterGroupResponse struct {
	*DeleteCacheParameterGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCacheParameterGroup request.
func (r *DeleteCacheParameterGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
