// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstancesInput
type DescribeInstancesInput struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet to retrieve instance information for.
	//
	// FleetId is a required field
	FleetId *string `type:"string" required:"true"`

	// Unique identifier for an instance to retrieve. Specify an instance ID or
	// leave blank to retrieve all instances in the fleet.
	InstanceId *string `type:"string"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstancesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeInstancesInput"}

	if s.FleetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("FleetId"))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstancesOutput
type DescribeInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Collection of objects containing properties for each instance returned.
	Instances []Instance `type:"list"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves information about a fleet's instances, including instance IDs.
// Use this action to get details on all instances in the fleet or get details
// on one specific instance.
//
// To get a specific instance, specify fleet ID and instance ID. To get all
// instances in a fleet, specify a fleet ID only. Use the pagination parameters
// to retrieve results as a set of sequential pages. If successful, an Instance
// object is returned for each result.
//
//    // Example sending a request using DescribeInstancesRequest.
//    req := client.DescribeInstancesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeInstances
func (c *Client) DescribeInstancesRequest(input *DescribeInstancesInput) DescribeInstancesRequest {
	op := &aws.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	req := c.newRequest(op, input, &DescribeInstancesOutput{})
	return DescribeInstancesRequest{Request: req, Input: input, Copy: c.DescribeInstancesRequest}
}

// DescribeInstancesRequest is the request type for the
// DescribeInstances API operation.
type DescribeInstancesRequest struct {
	*aws.Request
	Input *DescribeInstancesInput
	Copy  func(*DescribeInstancesInput) DescribeInstancesRequest
}

// Send marshals and sends the DescribeInstances API request.
func (r DescribeInstancesRequest) Send(ctx context.Context) (*DescribeInstancesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeInstancesResponse{
		DescribeInstancesOutput: r.Request.Data.(*DescribeInstancesOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeInstancesResponse is the response type for the
// DescribeInstances API operation.
type DescribeInstancesResponse struct {
	*DescribeInstancesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeInstances request.
func (r *DescribeInstancesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
