// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// Properties describing a fleet alias.
//
//    * CreateAlias
//
//    * ListAliases
//
//    * DescribeAlias
//
//    * UpdateAlias
//
//    * DeleteAlias
//
//    * ResolveAlias
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Alias
type Alias struct {
	_ struct{} `type:"structure"`

	// Unique identifier for an alias; alias ARNs are unique across all regions.
	AliasArn *string `min:"1" type:"string"`

	// Unique identifier for an alias; alias IDs are unique within a region.
	AliasId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Human-readable description of an alias.
	Description *string `type:"string"`

	// Time stamp indicating when this data object was last modified. Format is
	// a number expressed in Unix time as milliseconds (for example "1469498468.057").
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Descriptive label that is associated with an alias. Alias names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Alias configuration for the alias, including routing type and settings.
	RoutingStrategy *RoutingStrategy `type:"structure"`
}

// String returns the string representation
func (s Alias) String() string {
	return awsutil.Prettify(s)
}

// Values for use in Player attribute key:value pairs. This object lets you
// specify an attribute value using any of the valid data types: string, number,
// string array or data map. Each AttributeValue object can use only one of
// the available properties.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AttributeValue
type AttributeValue struct {
	_ struct{} `type:"structure"`

	// For number values, expressed as double.
	N *float64 `type:"double"`

	// For single string values. Maximum string length is 100 characters.
	S *string `min:"1" type:"string"`

	// For a map of up to 10 data type:value pairs. Maximum length for each string
	// value is 100 characters.
	SDM map[string]float64 `type:"map"`

	// For a list of up to 10 strings. Maximum length for each string is 100 characters.
	// Duplicate values are not recognized; all occurrences of the repeated value
	// after the first of a repeated value are ignored.
	SL []string `type:"list"`
}

// String returns the string representation
func (s AttributeValue) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttributeValue) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttributeValue"}
	if s.S != nil && len(*s.S) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("S", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Temporary access credentials used for uploading game build files to Amazon
// GameLift. They are valid for a limited time. If they expire before you upload
// your game build, get a new set by calling RequestUploadCredentials.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/AwsCredentials
type AwsCredentials struct {
	_ struct{} `type:"structure"`

	// Temporary key allowing access to the Amazon GameLift S3 account.
	AccessKeyId *string `min:"1" type:"string"`

	// Temporary secret key allowing access to the Amazon GameLift S3 account.
	SecretAccessKey *string `min:"1" type:"string"`

	// Token used to associate a specific build ID with the files uploaded using
	// these credentials.
	SessionToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AwsCredentials) String() string {
	return awsutil.Prettify(s)
}

// Properties describing a custom game build.
//
// Related operations
//
//    * CreateBuild
//
//    * ListBuilds
//
//    * DescribeBuild
//
//    * UpdateBuild
//
//    * DeleteBuild
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Build
type Build struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build.
	BuildId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Descriptive label that is associated with a build. Build names do not need
	// to be unique. It can be set using CreateBuild or UpdateBuild.
	Name *string `type:"string"`

	// Operating system that the game server binaries are built to run on. This
	// value determines the type of fleet resources that you can use for this build.
	OperatingSystem OperatingSystem `type:"string" enum:"true"`

	// File size of the uploaded game build, expressed in bytes. When the build
	// status is INITIALIZED, this value is 0.
	SizeOnDisk *int64 `min:"1" type:"long"`

	// Current status of the build.
	//
	// Possible build statuses include the following:
	//
	//    * INITIALIZED -- A new build has been defined, but no files have been
	//    uploaded. You cannot create fleets for builds that are in this status.
	//    When a build is successfully created, the build status is set to this
	//    value.
	//
	//    * READY -- The game build has been successfully uploaded. You can now
	//    create new fleets for this build.
	//
	//    * FAILED -- The game build upload failed. You cannot create new fleets
	//    for this build.
	Status BuildStatus `type:"string" enum:"true"`

	// Version that is associated with a build or script. Version strings do not
	// need to be unique. This value can be set using CreateBuild or UpdateBuild.
	Version *string `type:"string"`
}

// String returns the string representation
func (s Build) String() string {
	return awsutil.Prettify(s)
}

// Player information for use when creating player sessions using a game session
// placement request with StartGameSessionPlacement.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DesiredPlayerSession
type DesiredPlayerSession struct {
	_ struct{} `type:"structure"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player to associate with the player session.
	PlayerId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DesiredPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DesiredPlayerSession) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DesiredPlayerSession"}
	if s.PlayerData != nil && len(*s.PlayerData) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlayerData", 1))
	}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlayerId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Current status of fleet capacity. The number of active instances should match
// or be in the process of matching the number of desired instances. Pending
// and terminating counts are non-zero only if fleet capacity is adjusting to
// an UpdateFleetCapacity request, or if access to resources is temporarily
// affected.
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/EC2InstanceCounts
type EC2InstanceCounts struct {
	_ struct{} `type:"structure"`

	// Actual number of active instances in the fleet.
	ACTIVE *int64 `type:"integer"`

	// Ideal number of active instances in the fleet.
	DESIRED *int64 `type:"integer"`

	// Number of active instances in the fleet that are not currently hosting a
	// game session.
	IDLE *int64 `type:"integer"`

	// Maximum value allowed for the fleet's instance count.
	MAXIMUM *int64 `type:"integer"`

	// Minimum value allowed for the fleet's instance count.
	MINIMUM *int64 `type:"integer"`

	// Number of instances in the fleet that are starting but not yet active.
	PENDING *int64 `type:"integer"`

	// Number of instances in the fleet that are no longer active but haven't yet
	// been terminated.
	TERMINATING *int64 `type:"integer"`
}

// String returns the string representation
func (s EC2InstanceCounts) String() string {
	return awsutil.Prettify(s)
}

// Maximum number of instances allowed based on the Amazon Elastic Compute Cloud
// (Amazon EC2) instance type. Instance limits can be retrieved by calling DescribeEC2InstanceLimits.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/EC2InstanceLimit
type EC2InstanceLimit struct {
	_ struct{} `type:"structure"`

	// Number of instances of the specified type that are currently in use by this
	// AWS account.
	CurrentInstances *int64 `type:"integer"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	EC2InstanceType EC2InstanceType `type:"string" enum:"true"`

	// Number of instances allowed.
	InstanceLimit *int64 `type:"integer"`
}

// String returns the string representation
func (s EC2InstanceLimit) String() string {
	return awsutil.Prettify(s)
}

// Log entry describing an event that involves Amazon GameLift resources (such
// as a fleet). In addition to tracking activity, event codes and messages can
// provide additional information for troubleshooting and debugging problems.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Event
type Event struct {
	_ struct{} `type:"structure"`

	// Type of event being logged. The following events are currently in use:
	//
	// Fleet creation events:
	//
	//    * FLEET_CREATED -- A fleet record was successfully created with a status
	//    of NEW. Event messaging includes the fleet ID.
	//
	//    * FLEET_STATE_DOWNLOADING -- Fleet status changed from NEW to DOWNLOADING.
	//    The compressed build has started downloading to a fleet instance for installation.
	//
	//    * FLEET_BINARY_DOWNLOAD_FAILED -- The build failed to download to the
	//    fleet instance.
	//
	//    * FLEET_CREATION_EXTRACTING_BUILD – The game server build was successfully
	//    downloaded to an instance, and the build files are now being extracted
	//    from the uploaded build and saved to an instance. Failure at this stage
	//    prevents a fleet from moving to ACTIVE status. Logs for this stage display
	//    a list of the files that are extracted and saved on the instance. Access
	//    the logs by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_CREATION_RUNNING_INSTALLER – The game server build files were
	//    successfully extracted, and the Amazon GameLift is now running the build's
	//    install script (if one is included). Failure in this stage prevents a
	//    fleet from moving to ACTIVE status. Logs for this stage list the installation
	//    steps and whether or not the install completed successfully. Access the
	//    logs by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_CREATION_VALIDATING_RUNTIME_CONFIG -- The build process was successful,
	//    and the Amazon GameLift is now verifying that the game server launch paths,
	//    which are specified in the fleet's run-time configuration, exist. If any
	//    listed launch path exists, Amazon GameLift tries to launch a game server
	//    process and waits for the process to report ready. Failures in this stage
	//    prevent a fleet from moving to ACTIVE status. Logs for this stage list
	//    the launch paths in the run-time configuration and indicate whether each
	//    is found. Access the logs by using the URL in PreSignedLogUrl.
	//
	//    * FLEET_STATE_VALIDATING -- Fleet status changed from DOWNLOADING to VALIDATING.
	//
	//    * FLEET_VALIDATION_LAUNCH_PATH_NOT_FOUND -- Validation of the run-time
	//    configuration failed because the executable specified in a launch path
	//    does not exist on the instance.
	//
	//    * FLEET_STATE_BUILDING -- Fleet status changed from VALIDATING to BUILDING.
	//
	//    * FLEET_VALIDATION_EXECUTABLE_RUNTIME_FAILURE -- Validation of the run-time
	//    configuration failed because the executable specified in a launch path
	//    failed to run on the fleet instance.
	//
	//    * FLEET_STATE_ACTIVATING -- Fleet status changed from BUILDING to ACTIVATING.
	//
	//    * FLEET_ACTIVATION_FAILED - The fleet failed to successfully complete
	//    one of the steps in the fleet activation process. This event code indicates
	//    that the game build was successfully downloaded to a fleet instance, built,
	//    and validated, but was not able to start a server process. A possible
	//    reason for failure is that the game server is not reporting "process ready"
	//    to the Amazon GameLift service.
	//
	//    * FLEET_STATE_ACTIVE -- The fleet's status changed from ACTIVATING to
	//    ACTIVE. The fleet is now ready to host game sessions.
	//
	// VPC peering events:
	//
	//    * FLEET_VPC_PEERING_SUCCEEDED -- A VPC peering connection has been established
	//    between the VPC for an Amazon GameLift fleet and a VPC in your AWS account.
	//
	//    * FLEET_VPC_PEERING_FAILED -- A requested VPC peering connection has failed.
	//    Event details and status information (see DescribeVpcPeeringConnections)
	//    provide additional detail. A common reason for peering failure is that
	//    the two VPCs have overlapping CIDR blocks of IPv4 addresses. To resolve
	//    this, change the CIDR block for the VPC in your AWS account. For more
	//    information on VPC peering failures, see https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html
	//    (https://docs.aws.amazon.com/AmazonVPC/latest/PeeringGuide/invalid-peering-configurations.html)
	//
	//    * FLEET_VPC_PEERING_DELETED -- A VPC peering connection has been successfully
	//    deleted.
	//
	// Spot instance events:
	//
	//    * INSTANCE_INTERRUPTED -- A spot instance was interrupted by EC2 with
	//    a two-minute notification.
	//
	// Other fleet events:
	//
	//    * FLEET_SCALING_EVENT -- A change was made to the fleet's capacity settings
	//    (desired instances, minimum/maximum scaling limits). Event messaging includes
	//    the new capacity settings.
	//
	//    * FLEET_NEW_GAME_SESSION_PROTECTION_POLICY_UPDATED -- A change was made
	//    to the fleet's game session protection policy setting. Event messaging
	//    includes both the old and new policy setting.
	//
	//    * FLEET_DELETED -- A request to delete a fleet was initiated.
	//
	//    * GENERIC_EVENT -- An unspecified event has occurred.
	EventCode EventCode `type:"string" enum:"true"`

	// Unique identifier for a fleet event.
	EventId *string `min:"1" type:"string"`

	// Time stamp indicating when this event occurred. Format is a number expressed
	// in Unix time as milliseconds (for example "1469498468.057").
	EventTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Additional information related to the event.
	Message *string `min:"1" type:"string"`

	// Location of stored logs with additional detail that is related to the event.
	// This is useful for debugging issues. The URL is valid for 15 minutes. You
	// can also access fleet creation logs through the Amazon GameLift console.
	PreSignedLogUrl *string `min:"1" type:"string"`

	// Unique identifier for an event resource, such as a fleet ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// General properties describing a fleet.
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/FleetAttributes
type FleetAttributes struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a build.
	BuildId *string `type:"string"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Human-readable description of the fleet.
	Description *string `min:"1" type:"string"`

	// Identifier for a fleet that is unique across all regions.
	FleetArn *string `min:"1" type:"string"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Indicates whether the fleet uses on-demand or spot instances. A spot instance
	// in use may be interrupted with a two-minute notification.
	FleetType FleetType `type:"string" enum:"true"`

	// Unique identifier for an AWS IAM role that manages access to your AWS services.
	// With an instance role ARN set, any application that runs on an instance in
	// this fleet can assume the role, including install scripts, server processes,
	// daemons (background processes). Create a role or look up a role's ARN using
	// the IAM dashboard (https://console.aws.amazon.com/iam/) in the AWS Management
	// Console. Learn more about using on-box credentials for your game servers
	// at Access external resources from a game server (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-resources.html).
	InstanceRoleArn *string `min:"1" type:"string"`

	// EC2 instance type indicating the computing resources of each instance in
	// the fleet, including CPU, memory, storage, and networking capacity. See Amazon
	// EC2 Instance Types (http://aws.amazon.com/ec2/instance-types/) for detailed
	// descriptions.
	InstanceType EC2InstanceType `type:"string" enum:"true"`

	// Location of default log files. When a server process is shut down, Amazon
	// GameLift captures and stores any log files in this location. These logs are
	// in addition to game session logs; see more on game session logs in the Amazon
	// GameLift Developer Guide (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-api-server-code).
	// If no default log path for a fleet is specified, Amazon GameLift automatically
	// uploads logs that are stored on each instance at C:\game\logs (for Windows)
	// or /local/game/logs (for Linux). Use the Amazon GameLift console to access
	// stored logs.
	LogPaths []string `type:"list"`

	// Names of metric groups that this fleet is included in. In Amazon CloudWatch,
	// you can view metrics for an individual fleet or aggregated metrics for fleets
	// that are in a fleet metric group. A fleet can be included in only one metric
	// group at a time.
	MetricGroups []string `type:"list"`

	// Descriptive label that is associated with a fleet. Fleet names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Type of game session protection to set for all new instances started in the
	// fleet.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	NewGameSessionProtectionPolicy ProtectionPolicy `type:"string" enum:"true"`

	// Operating system of the fleet's computing resources. A fleet's operating
	// system depends on the OS specified for the build that is deployed on this
	// fleet.
	OperatingSystem OperatingSystem `type:"string" enum:"true"`

	// Fleet policy to limit the number of game sessions an individual player can
	// create over a span of time.
	ResourceCreationLimitPolicy *ResourceCreationLimitPolicy `type:"structure"`

	// Unique identifier for a Realtime script.
	ScriptId *string `type:"string"`

	// Game server launch parameters specified for fleets created before 2016-08-04
	// (or AWS SDK v. 0.12.16). Server launch parameters for fleets created after
	// this date are specified in the fleet's RuntimeConfiguration.
	ServerLaunchParameters *string `min:"1" type:"string"`

	// Path to a game server executable in the fleet's build, specified for fleets
	// created before 2016-08-04 (or AWS SDK v. 0.12.16). Server launch paths for
	// fleets created after this date are specified in the fleet's RuntimeConfiguration.
	ServerLaunchPath *string `min:"1" type:"string"`

	// Current status of the fleet.
	//
	// Possible fleet statuses include the following:
	//
	//    * NEW -- A new fleet has been defined and desired instances is set to
	//    1.
	//
	//    * DOWNLOADING/VALIDATING/BUILDING/ACTIVATING -- Amazon GameLift is setting
	//    up the new fleet, creating new instances with the game build or Realtime
	//    script and starting server processes.
	//
	//    * ACTIVE -- Hosts can now accept game sessions.
	//
	//    * ERROR -- An error occurred when downloading, validating, building, or
	//    activating the fleet.
	//
	//    * DELETING -- Hosts are responding to a delete fleet request.
	//
	//    * TERMINATED -- The fleet no longer exists.
	Status FleetStatus `type:"string" enum:"true"`

	// List of fleet actions that have been suspended using StopFleetActions. This
	// includes auto-scaling.
	StoppedActions []FleetAction `min:"1" type:"list"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s FleetAttributes) String() string {
	return awsutil.Prettify(s)
}

// Information about the fleet's capacity. Fleet capacity is measured in EC2
// instances. By default, new fleets have a capacity of one instance, but can
// be updated as needed. The maximum number of instances for a fleet is determined
// by the fleet's instance type.
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/FleetCapacity
type FleetCapacity struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Current status of fleet capacity.
	InstanceCounts *EC2InstanceCounts `type:"structure"`

	// Name of an EC2 instance type that is supported in Amazon GameLift. A fleet
	// instance type determines the computing resources of each instance in the
	// fleet, including CPU, memory, storage, and networking capacity. Amazon GameLift
	// supports the following EC2 instance types. See Amazon EC2 Instance Types
	// (http://aws.amazon.com/ec2/instance-types/) for detailed descriptions.
	InstanceType EC2InstanceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s FleetCapacity) String() string {
	return awsutil.Prettify(s)
}

// Current status of fleet utilization, including the number of game and player
// sessions being hosted.
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/FleetUtilization
type FleetUtilization struct {
	_ struct{} `type:"structure"`

	// Number of active game sessions currently being hosted on all instances in
	// the fleet.
	ActiveGameSessionCount *int64 `type:"integer"`

	// Number of server processes in an ACTIVE status currently running across all
	// instances in the fleet
	ActiveServerProcessCount *int64 `type:"integer"`

	// Number of active player sessions currently being hosted on all instances
	// in the fleet.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// Unique identifier for a fleet.
	FleetId *string `type:"string"`

	// Maximum players allowed across all game sessions currently being hosted on
	// all instances in the fleet.
	MaximumPlayerSessionCount *int64 `type:"integer"`
}

// String returns the string representation
func (s FleetUtilization) String() string {
	return awsutil.Prettify(s)
}

// Set of key-value pairs that contain information about a game session. When
// included in a game session request, these properties communicate details
// to be used when setting up the new game session, such as to specify a game
// mode, level, or map. Game properties are passed to the game server process
// when initiating a new game session; the server process uses the properties
// as appropriate. For more information, see the Amazon GameLift Developer Guide
// (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-client-api.html#gamelift-sdk-client-api-create).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameProperty
type GameProperty struct {
	_ struct{} `type:"structure"`

	// Game property identifier.
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// Game property value.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GameProperty) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameProperty) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GameProperty"}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}

	if s.Value == nil {
		invalidParams.Add(aws.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Properties describing a game session.
//
// A game session in ACTIVE status can host players. When a game session ends,
// its status is set to TERMINATED.
//
// Once the session ends, the game session object is retained for 30 days. This
// means you can reuse idempotency token values after this time. Game session
// logs are retained for 14 days.
//
//    * CreateGameSession
//
//    * DescribeGameSessions
//
//    * DescribeGameSessionDetails
//
//    * SearchGameSessions
//
//    * UpdateGameSession
//
//    * GetGameSessionLogUrl
//
//    * Game session placements StartGameSessionPlacement DescribeGameSessionPlacement
//    StopGameSessionPlacement
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSession
type GameSession struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a player. This ID is used to enforce a resource protection
	// policy (if one exists), that limits the number of game sessions a player
	// can create.
	CreatorId *string `min:"1" type:"string"`

	// Number of players currently in the game session.
	CurrentPlayerSessionCount *int64 `type:"integer"`

	// Unique identifier for a fleet that the game session is running on.
	FleetId *string `type:"string"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// You can search for active game sessions based on this custom data with SearchGameSessions.
	GameProperties []GameProperty `type:"list"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// Unique identifier for the game session. A game session ARN has the following
	// format: arn:aws:gamelift:<region>::gamesession/<fleet ID>/<custom ID string
	// or idempotency token>.
	GameSessionId *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	IpAddress *string `type:"string"`

	// Information about the matchmaking process that was used to create the game
	// session. It is in JSON syntax, formatted as a string. In addition the matchmaking
	// configuration used, it contains data on all players assigned to the match,
	// including player attributes and team assignments. For more details on matchmaker
	// data, see Match Data (https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data).
	// Matchmaker data is useful when requesting match backfills, and is updated
	// whenever new players are added during a successful backfill (see StartMatchBackfill).
	MatchmakerData *string `min:"1" type:"string"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	Name *string `min:"1" type:"string"`

	// Indicates whether or not the game session is accepting new players.
	PlayerSessionCreationPolicy PlayerSessionCreationPolicy `type:"string" enum:"true"`

	// Port number for the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`

	// Current status of the game session. A game session must have an ACTIVE status
	// to have player sessions.
	Status GameSessionStatus `type:"string" enum:"true"`

	// Provides additional information about game session status. INTERRUPTED indicates
	// that the game session was hosted on a spot instance that was reclaimed, causing
	// the active game session to be terminated.
	StatusReason GameSessionStatusReason `type:"string" enum:"true"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s GameSession) String() string {
	return awsutil.Prettify(s)
}

// Connection information for the new game session that is created with matchmaking.
// (with StartMatchmaking). Once a match is set, the FlexMatch engine places
// the match and creates a new game session for it. This information, including
// the game session endpoint and player sessions for each player in the original
// matchmaking request, is added to the MatchmakingTicket, which can be retrieved
// by calling DescribeMatchmaking.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionConnectionInfo
type GameSessionConnectionInfo struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session and uniquely identifies it.
	GameSessionArn *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	IpAddress *string `type:"string"`

	// Collection of player session IDs, one for each player ID that was included
	// in the original matchmaking request.
	MatchedPlayerSessions []MatchedPlayerSession `type:"list"`

	// Port number for the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s GameSessionConnectionInfo) String() string {
	return awsutil.Prettify(s)
}

// A game session's properties plus the protection policy currently in force.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionDetail
type GameSessionDetail struct {
	_ struct{} `type:"structure"`

	// Object that describes a game session.
	GameSession *GameSession `type:"structure"`

	// Current status of protection for the game session.
	//
	//    * NoProtection -- The game session can be terminated during a scale-down
	//    event.
	//
	//    * FullProtection -- If the game session is in an ACTIVE status, it cannot
	//    be terminated during a scale-down event.
	ProtectionPolicy ProtectionPolicy `type:"string" enum:"true"`
}

// String returns the string representation
func (s GameSessionDetail) String() string {
	return awsutil.Prettify(s)
}

// Object that describes a StartGameSessionPlacement request. This object includes
// the full details of the original request plus the current status and start/end
// time stamps.
//
// Game session placement-related operations include:
//
//    * StartGameSessionPlacement
//
//    * DescribeGameSessionPlacement
//
//    * StopGameSessionPlacement
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionPlacement
type GameSessionPlacement struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this request was completed, canceled, or timed
	// out.
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameProperties []GameProperty `type:"list"`

	// Identifier for the game session created by this placement request. This value
	// is set once the new game session is placed (placement status is FULFILLED).
	// This identifier is unique across all regions. You can use this value as a
	// GameSessionId value as needed.
	GameSessionArn *string `min:"1" type:"string"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	GameSessionData *string `min:"1" type:"string"`

	// Unique identifier for the game session. This value is set once the new game
	// session is placed (placement status is FULFILLED).
	GameSessionId *string `min:"1" type:"string"`

	// Descriptive label that is associated with a game session. Session names do
	// not need to be unique.
	GameSessionName *string `min:"1" type:"string"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	GameSessionQueueName *string `min:"1" type:"string"`

	// Name of the region where the game session created by this placement request
	// is running. This value is set once the new game session is placed (placement
	// status is FULFILLED).
	GameSessionRegion *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number. This value is set once
	// the new game session is placed (placement status is FULFILLED).
	IpAddress *string `type:"string"`

	// Information on the matchmaking process for this game. Data is in JSON syntax,
	// formatted as a string. It identifies the matchmaking configuration used to
	// create the match, and contains data on all players assigned to the match,
	// including player attributes and team assignments. For more details on matchmaker
	// data, see Match Data (https://docs.aws.amazon.com/gamelift/latest/developerguide/match-server.html#match-server-data).
	MatchmakerData *string `min:"1" type:"string"`

	// Maximum number of players that can be connected simultaneously to the game
	// session.
	MaximumPlayerSessionCount *int64 `type:"integer"`

	// Collection of information on player sessions created in response to the game
	// session placement request. These player sessions are created only once a
	// new game session is successfully placed (placement status is FULFILLED).
	// This information includes the player ID (as provided in the placement request)
	// and the corresponding player session ID. Retrieve full player sessions by
	// calling DescribePlayerSessions with the player session ID.
	PlacedPlayerSessions []PlacedPlayerSession `type:"list"`

	// Unique identifier for a game session placement.
	PlacementId *string `min:"1" type:"string"`

	// Set of values, expressed in milliseconds, indicating the amount of latency
	// that a player experiences when connected to AWS regions.
	PlayerLatencies []PlayerLatency `type:"list"`

	// Port number for the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number. This value is set once
	// the new game session is placed (placement status is FULFILLED).
	Port *int64 `min:"1" type:"integer"`

	// Time stamp indicating when this request was placed in the queue. Format is
	// a number expressed in Unix time as milliseconds (for example "1469498468.057").
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Current status of the game session placement request.
	//
	//    * PENDING -- The placement request is currently in the queue waiting to
	//    be processed.
	//
	//    * FULFILLED -- A new game session and player sessions (if requested) have
	//    been successfully created. Values for GameSessionArn and GameSessionRegion
	//    are available.
	//
	//    * CANCELLED -- The placement request was canceled with a call to StopGameSessionPlacement.
	//
	//    * TIMED_OUT -- A new game session was not successfully created before
	//    the time limit expired. You can resubmit the placement request as needed.
	Status GameSessionPlacementState `type:"string" enum:"true"`
}

// String returns the string representation
func (s GameSessionPlacement) String() string {
	return awsutil.Prettify(s)
}

// Configuration of a queue that is used to process game session placement requests.
// The queue configuration identifies several game features:
//
//    * The destinations where a new game session can potentially be hosted.
//    Amazon GameLift tries these destinations in an order based on either the
//    queue's default order or player latency information, if provided in a
//    placement request. With latency information, Amazon GameLift can place
//    game sessions where the majority of players are reporting the lowest possible
//    latency.
//
//    * The length of time that placement requests can wait in the queue before
//    timing out.
//
//    * A set of optional latency policies that protect individual players from
//    high latencies, preventing game sessions from being placed where any individual
//    player is reporting latency higher than a policy's maximum.
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionQueue
type GameSessionQueue struct {
	_ struct{} `type:"structure"`

	// List of fleets that can be used to fulfill game session placement requests
	// in the queue. Fleets are identified by either a fleet ARN or a fleet alias
	// ARN. Destinations are listed in default preference order.
	Destinations []GameSessionQueueDestination `type:"list"`

	// Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session queue and uniquely identifies it. Format
	// is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	GameSessionQueueArn *string `min:"1" type:"string"`

	// Descriptive label that is associated with game session queue. Queue names
	// must be unique within each region.
	Name *string `min:"1" type:"string"`

	// Collection of latency policies to apply when processing game sessions placement
	// requests with player latency information. Multiple policies are evaluated
	// in order of the maximum latency value, starting with the lowest latency values.
	// With just one policy, it is enforced at the start of the game session placement
	// for the duration period. With multiple policies, each policy is enforced
	// consecutively for its duration period. For example, a queue might enforce
	// a 60-second policy followed by a 120-second policy, and then no policy for
	// the remainder of the placement.
	PlayerLatencyPolicies []PlayerLatencyPolicy `type:"list"`

	// Maximum time, in seconds, that a new game session placement request remains
	// in the queue. When a request exceeds this time, the game session placement
	// changes to a TIMED_OUT status.
	TimeoutInSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s GameSessionQueue) String() string {
	return awsutil.Prettify(s)
}

// Fleet designated in a game session queue. Requests for new game sessions
// in the queue are fulfilled by starting a new game session on any destination
// configured for a queue.
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/GameSessionQueueDestination
type GameSessionQueueDestination struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) assigned to fleet or fleet alias. ARNs, which
	// include a fleet ID or alias ID and a region name, provide a unique identifier
	// across all regions.
	DestinationArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GameSessionQueueDestination) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GameSessionQueueDestination) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GameSessionQueueDestination"}
	if s.DestinationArn != nil && len(*s.DestinationArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("DestinationArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Properties that describe an instance of a virtual computing resource that
// hosts one or more game servers. A fleet may contain zero or more instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Instance
type Instance struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a fleet that the instance is in.
	FleetId *string `type:"string"`

	// Unique identifier for an instance.
	InstanceId *string `type:"string"`

	// IP address assigned to the instance.
	IpAddress *string `type:"string"`

	// Operating system that is running on this instance.
	OperatingSystem OperatingSystem `type:"string" enum:"true"`

	// Current status of the instance. Possible statuses include the following:
	//
	//    * PENDING -- The instance is in the process of being created and launching
	//    server processes as defined in the fleet's run-time configuration.
	//
	//    * ACTIVE -- The instance has been successfully created and at least one
	//    server process has successfully launched and reported back to Amazon GameLift
	//    that it is ready to host a game session. The instance is now considered
	//    ready to host game sessions.
	//
	//    * TERMINATING -- The instance is in the process of shutting down. This
	//    may happen to reduce capacity during a scaling down event or to recycle
	//    resources in the event of a problem.
	Status InstanceStatus `type:"string" enum:"true"`

	// EC2 instance type that defines the computing resources of this instance.
	Type EC2InstanceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// Information required to remotely connect to a fleet instance. Access is requested
// by calling GetInstanceAccess.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/InstanceAccess
type InstanceAccess struct {
	_ struct{} `type:"structure"`

	// Credentials required to access the instance.
	Credentials *InstanceCredentials `type:"structure"`

	// Unique identifier for a fleet containing the instance being accessed.
	FleetId *string `type:"string"`

	// Unique identifier for an instance being accessed.
	InstanceId *string `type:"string"`

	// IP address assigned to the instance.
	IpAddress *string `type:"string"`

	// Operating system that is running on the instance.
	OperatingSystem OperatingSystem `type:"string" enum:"true"`
}

// String returns the string representation
func (s InstanceAccess) String() string {
	return awsutil.Prettify(s)
}

// Set of credentials required to remotely access a fleet instance. Access credentials
// are requested by calling GetInstanceAccess and returned in an InstanceAccess
// object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/InstanceCredentials
type InstanceCredentials struct {
	_ struct{} `type:"structure"`

	// Secret string. For Windows instances, the secret is a password for use with
	// Windows Remote Desktop. For Linux instances, it is a private key (which must
	// be saved as a .pem file) for use with SSH.
	Secret *string `min:"1" type:"string"`

	// User login string.
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s InstanceCredentials) String() string {
	return awsutil.Prettify(s)
}

// A range of IP addresses and port settings that allow inbound traffic to connect
// to server processes on an Amazon GameLift. New game sessions that are started
// on the fleet are assigned an IP address/port number combination, which must
// fall into the fleet's allowed ranges. For fleets created with a custom game
// server, the ranges reflect the server's game session assignments. For Realtime
// Servers fleets, Amazon GameLift automatically opens two port ranges, one
// for TCP messaging and one for UDP for use by the Realtime servers.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/IpPermission
type IpPermission struct {
	_ struct{} `type:"structure"`

	// Starting value for a range of allowed port numbers.
	//
	// FromPort is a required field
	FromPort *int64 `min:"1" type:"integer" required:"true"`

	// Range of allowed IP addresses. This value must be expressed in CIDR notation.
	// Example: "000.000.000.000/[subnet mask]" or optionally the shortened version
	// "0.0.0.0/[subnet mask]".
	//
	// IpRange is a required field
	IpRange *string `type:"string" required:"true"`

	// Network communication protocol used by the fleet.
	//
	// Protocol is a required field
	Protocol IpProtocol `type:"string" required:"true" enum:"true"`

	// Ending value for a range of allowed port numbers. Port numbers are end-inclusive.
	// This value must be higher than FromPort.
	//
	// ToPort is a required field
	ToPort *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s IpPermission) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IpPermission) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "IpPermission"}

	if s.FromPort == nil {
		invalidParams.Add(aws.NewErrParamRequired("FromPort"))
	}
	if s.FromPort != nil && *s.FromPort < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("FromPort", 1))
	}

	if s.IpRange == nil {
		invalidParams.Add(aws.NewErrParamRequired("IpRange"))
	}
	if len(s.Protocol) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Protocol"))
	}

	if s.ToPort == nil {
		invalidParams.Add(aws.NewErrParamRequired("ToPort"))
	}
	if s.ToPort != nil && *s.ToPort < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ToPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents a new player session that is created as a result of a successful
// FlexMatch match. A successful match automatically creates new player sessions
// for every player ID in the original matchmaking request.
//
// When players connect to the match's game session, they must include both
// player ID and player session ID in order to claim their assigned player slot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/MatchedPlayerSession
type MatchedPlayerSession struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a player
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session
	PlayerSessionId *string `type:"string"`
}

// String returns the string representation
func (s MatchedPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// Guidelines for use with FlexMatch to match players into games. All matchmaking
// requests must specify a matchmaking configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/MatchmakingConfiguration
type MatchmakingConfiguration struct {
	_ struct{} `type:"structure"`

	// Flag that determines whether or not a match that was created with this configuration
	// must be accepted by the matched players. To require acceptance, set to TRUE.
	AcceptanceRequired *bool `type:"boolean"`

	// Length of time (in seconds) to wait for players to accept a proposed match.
	// If any player rejects the match or fails to accept before the timeout, the
	// ticket continues to look for an acceptable match.
	AcceptanceTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Number of player slots in a match to keep open for future players. For example,
	// if the configuration's rule set specifies a match for a single 12-person
	// team, and the additional player count is set to 2, only 10 players are selected
	// for the match.
	AdditionalPlayerCount *int64 `type:"integer"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Information to attached to all events related to the matchmaking configuration.
	CustomEventData *string `type:"string"`

	// Descriptive label that is associated with matchmaking configuration.
	Description *string `min:"1" type:"string"`

	// Set of custom properties for a game session, formatted as key:value pairs.
	// These properties are passed to a game server process in the GameSession object
	// with a request to start a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match.
	GameProperties []GameProperty `type:"list"`

	// Set of custom game session properties, formatted as a single string value.
	// This data is passed to a game server process in the GameSession object with
	// a request to start a new game session (see Start a Game Session (https://docs.aws.amazon.com/gamelift/latest/developerguide/gamelift-sdk-server-api.html#gamelift-sdk-server-startsession)).
	// This information is added to the new GameSession object that is created for
	// a successful match.
	GameSessionData *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// that is assigned to a game session queue and uniquely identifies it. Format
	// is arn:aws:gamelift:<region>::fleet/fleet-a1234567-b8c9-0d1e-2fa3-b45c6d7e8912.
	// These queues are used when placing game sessions for matches that are created
	// with this matchmaking configuration. Queues can be located in any region.
	GameSessionQueueArns []string `type:"list"`

	// Unique identifier for a matchmaking configuration. This name is used to identify
	// the configuration associated with a matchmaking request or ticket.
	Name *string `min:"1" type:"string"`

	// SNS topic ARN that is set up to receive matchmaking notifications.
	NotificationTarget *string `type:"string"`

	// Maximum duration, in seconds, that a matchmaking ticket can remain in process
	// before timing out. Requests that time out can be resubmitted as needed.
	RequestTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Unique identifier for a matchmaking rule set to use with this configuration.
	// A matchmaking configuration can only use rule sets that are defined in the
	// same region.
	RuleSetName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MatchmakingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Set of rule statements, used with FlexMatch, that determine how to build
// a certain kind of player match. Each rule set describes a type of group to
// be created and defines the parameters for acceptable player matches. Rule
// sets are used in MatchmakingConfiguration objects.
//
// A rule set may define the following elements for a match. For detailed information
// and examples showing how to construct a rule set, see Build a FlexMatch Rule
// Set (https://docs.aws.amazon.com/gamelift/latest/developerguide/match-rulesets.html).
//
//    * Teams -- Required. A rule set must define one or multiple teams for
//    the match and set minimum and maximum team sizes. For example, a rule
//    set might describe a 4x4 match that requires all eight slots to be filled.
//
//    * Player attributes -- Optional. These attributes specify a set of player
//    characteristics to evaluate when looking for a match. Matchmaking requests
//    that use a rule set with player attributes must provide the corresponding
//    attribute values. For example, an attribute might specify a player's skill
//    or level.
//
//    * Rules -- Optional. Rules define how to evaluate potential players for
//    a match based on player attributes. A rule might specify minimum requirements
//    for individual players, teams, or entire matches. For example, a rule
//    might require each player to meet a certain skill level, each team to
//    have at least one player in a certain role, or the match to have a minimum
//    average skill level. or may describe an entire group--such as all teams
//    must be evenly matched or have at least one player in a certain role.
//
//    * Expansions -- Optional. Expansions allow you to relax the rules after
//    a period of time when no acceptable matches are found. This feature lets
//    you balance getting players into games in a reasonable amount of time
//    instead of making them wait indefinitely for the best possible match.
//    For example, you might use an expansion to increase the maximum skill
//    variance between players after 30 seconds.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/MatchmakingRuleSet
type MatchmakingRuleSet struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Collection of matchmaking rules, formatted as a JSON string. (Note that comments14
	// are not allowed in JSON, but most elements support a description field.)
	//
	// RuleSetBody is a required field
	RuleSetBody *string `min:"1" type:"string" required:"true"`

	// Unique identifier for a matchmaking rule set
	RuleSetName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MatchmakingRuleSet) String() string {
	return awsutil.Prettify(s)
}

// Ticket generated to track the progress of a matchmaking request. Each ticket
// is uniquely identified by a ticket ID, supplied by the requester, when creating
// a matchmaking request with StartMatchmaking. Tickets can be retrieved by
// calling DescribeMatchmaking with the ticket ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/MatchmakingTicket
type MatchmakingTicket struct {
	_ struct{} `type:"structure"`

	// Name of the MatchmakingConfiguration that is used with this ticket. Matchmaking
	// configurations determine how players are grouped into a match and how a new
	// game session is created for the match.
	ConfigurationName *string `min:"1" type:"string"`

	// Time stamp indicating when this matchmaking request stopped being processed
	// due to success, failure, or cancellation. Format is a number expressed in
	// Unix time as milliseconds (for example "1469498468.057").
	EndTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Average amount of time (in seconds) that players are currently waiting for
	// a match. If there is not enough recent data, this property may be empty.
	EstimatedWaitTime *int64 `type:"integer"`

	// Identifier and connection information of the game session created for the
	// match. This information is added to the ticket only after the matchmaking
	// request has been successfully completed.
	GameSessionConnectionInfo *GameSessionConnectionInfo `type:"structure"`

	// A set of Player objects, each representing a player to find matches for.
	// Players are identified by a unique player ID and may include latency data
	// for use during matchmaking. If the ticket is in status COMPLETED, the Player
	// objects include the team the players were assigned to in the resulting match.
	Players []Player `type:"list"`

	// Time stamp indicating when this matchmaking request was received. Format
	// is a number expressed in Unix time as milliseconds (for example "1469498468.057").
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Current status of the matchmaking request.
	//
	//    * QUEUED -- The matchmaking request has been received and is currently
	//    waiting to be processed.
	//
	//    * SEARCHING -- The matchmaking request is currently being processed.
	//
	//    * REQUIRES_ACCEPTANCE -- A match has been proposed and the players must
	//    accept the match (see AcceptMatch). This status is used only with requests
	//    that use a matchmaking configuration with a player acceptance requirement.
	//
	//    * PLACING -- The FlexMatch engine has matched players and is in the process
	//    of placing a new game session for the match.
	//
	//    * COMPLETED -- Players have been matched and a game session is ready to
	//    host the players. A ticket in this state contains the necessary connection
	//    information for players.
	//
	//    * FAILED -- The matchmaking request was not completed. Tickets with players
	//    who fail to accept a proposed match are placed in FAILED status.
	//
	//    * CANCELLED -- The matchmaking request was canceled with a call to StopMatchmaking.
	//
	//    * TIMED_OUT -- The matchmaking request was not successful within the duration
	//    specified in the matchmaking configuration.
	//
	// Matchmaking requests that fail to successfully complete (statuses FAILED,
	// CANCELLED, TIMED_OUT) can be resubmitted as new requests with new ticket
	// IDs.
	Status MatchmakingConfigurationStatus `type:"string" enum:"true"`

	// Additional information about the current status.
	StatusMessage *string `type:"string"`

	// Code to explain the current status. For example, a status reason may indicate
	// when a ticket has returned to SEARCHING status after a proposed match fails
	// to receive player acceptances.
	StatusReason *string `type:"string"`

	// Unique identifier for a matchmaking ticket.
	TicketId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s MatchmakingTicket) String() string {
	return awsutil.Prettify(s)
}

// Information about a player session that was created as part of a StartGameSessionPlacement
// request. This object contains only the player ID and player session ID. To
// retrieve full details on a player session, call DescribePlayerSessions with
// the player session ID.
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements StartGameSessionPlacement DescribeGameSessionPlacement
//    StopGameSessionPlacement
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PlacedPlayerSession
type PlacedPlayerSession struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a player that is associated with this player session.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session.
	PlayerSessionId *string `type:"string"`
}

// String returns the string representation
func (s PlacedPlayerSession) String() string {
	return awsutil.Prettify(s)
}

// Represents a player in matchmaking. When starting a matchmaking request,
// a player has a player ID, attributes, and may have latency data. Team information
// is added after a match has been successfully completed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Player
type Player struct {
	_ struct{} `type:"structure"`

	// Set of values, expressed in milliseconds, indicating the amount of latency
	// that a player experiences when connected to AWS regions. If this property
	// is present, FlexMatch considers placing the match only in regions for which
	// latency is reported.
	//
	// If a matchmaker has a rule that evaluates player latency, players must report
	// latency in order to be matched. If no latency is reported in this scenario,
	// FlexMatch assumes that no regions are available to the player and the ticket
	// is not matchable.
	LatencyInMs map[string]int64 `type:"map"`

	// Collection of key:value pairs containing player information for use in matchmaking.
	// Player attribute keys must match the playerAttributes used in a matchmaking
	// rule set. Example: "PlayerAttributes": {"skill": {"N": "23"}, "gameMode":
	// {"S": "deathmatch"}}.
	PlayerAttributes map[string]AttributeValue `type:"map"`

	// Unique identifier for a player
	PlayerId *string `min:"1" type:"string"`

	// Name of the team that the player is assigned to in a match. Team names are
	// defined in a matchmaking rule set.
	Team *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Player) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Player) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Player"}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlayerId", 1))
	}
	if s.Team != nil && len(*s.Team) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Team", 1))
	}
	if s.PlayerAttributes != nil {
		for i, v := range s.PlayerAttributes {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PlayerAttributes", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Regional latency information for a player, used when requesting a new game
// session with StartGameSessionPlacement. This value indicates the amount of
// time lag that exists when the player is connected to a fleet in the specified
// region. The relative difference between a player's latency values for multiple
// regions are used to determine which fleets are best suited to place a new
// game session for the player.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PlayerLatency
type PlayerLatency struct {
	_ struct{} `type:"structure"`

	// Amount of time that represents the time lag experienced by the player when
	// connected to the specified region.
	LatencyInMilliseconds *float64 `type:"float"`

	// Unique identifier for a player associated with the latency data.
	PlayerId *string `min:"1" type:"string"`

	// Name of the region that is associated with the latency value.
	RegionIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PlayerLatency) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlayerLatency) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PlayerLatency"}
	if s.PlayerId != nil && len(*s.PlayerId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PlayerId", 1))
	}
	if s.RegionIdentifier != nil && len(*s.RegionIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RegionIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Queue setting that determines the highest latency allowed for individual
// players when placing a game session. When a latency policy is in force, a
// game session cannot be placed at any destination in a region where a player
// is reporting latency higher than the cap. Latency policies are only enforced
// when the placement request contains player latency information.
//
//    * CreateGameSessionQueue
//
//    * DescribeGameSessionQueues
//
//    * UpdateGameSessionQueue
//
//    * DeleteGameSessionQueue
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PlayerLatencyPolicy
type PlayerLatencyPolicy struct {
	_ struct{} `type:"structure"`

	// The maximum latency value that is allowed for any player, in milliseconds.
	// All policies must have a value set for this property.
	MaximumIndividualPlayerLatencyMilliseconds *int64 `type:"integer"`

	// The length of time, in seconds, that the policy is enforced while placing
	// a new game session. A null value for this property means that the policy
	// is enforced until the queue times out.
	PolicyDurationSeconds *int64 `type:"integer"`
}

// String returns the string representation
func (s PlayerLatencyPolicy) String() string {
	return awsutil.Prettify(s)
}

// Properties describing a player session. Player session objects are created
// either by creating a player session for a specific game session, or as part
// of a game session placement. A player session represents either a player
// reservation for a game session (status RESERVED) or actual player activity
// in a game session (status ACTIVE). A player session object (including player
// data) is automatically passed to a game session when the player connects
// to the game session and is validated.
//
// When a player disconnects, the player session status changes to COMPLETED.
// Once the session ends, the player session object is retained for 30 days
// and then removed.
//
//    * CreatePlayerSession
//
//    * CreatePlayerSessions
//
//    * DescribePlayerSessions
//
//    * Game session placements StartGameSessionPlacement DescribeGameSessionPlacement
//    StopGameSessionPlacement
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/PlayerSession
type PlayerSession struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for a fleet that the player's game session is running on.
	FleetId *string `type:"string"`

	// Unique identifier for the game session that the player session is connected
	// to.
	GameSessionId *string `min:"1" type:"string"`

	// IP address of the game session. To connect to a Amazon GameLift game server,
	// an app needs both the IP address and port number.
	IpAddress *string `type:"string"`

	// Developer-defined information related to a player. Amazon GameLift does not
	// use this data, so it can be formatted as needed for use in the game.
	PlayerData *string `min:"1" type:"string"`

	// Unique identifier for a player that is associated with this player session.
	PlayerId *string `min:"1" type:"string"`

	// Unique identifier for a player session.
	PlayerSessionId *string `type:"string"`

	// Port number for the game session. To connect to a Amazon GameLift server
	// process, an app needs both the IP address and port number.
	Port *int64 `min:"1" type:"integer"`

	// Current status of the player session.
	//
	// Possible player session statuses include the following:
	//
	//    * RESERVED -- The player session request has been received, but the player
	//    has not yet connected to the server process and/or been validated.
	//
	//    * ACTIVE -- The player has been validated by the server process and is
	//    currently connected.
	//
	//    * COMPLETED -- The player connection has been dropped.
	//
	//    * TIMEDOUT -- A player session request was received, but the player did
	//    not connect and/or was not validated within the timeout limit (60 seconds).
	Status PlayerSessionStatus `type:"string" enum:"true"`

	// Time stamp indicating when this data object was terminated. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	TerminationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s PlayerSession) String() string {
	return awsutil.Prettify(s)
}

// Policy that limits the number of game sessions a player can create on the
// same fleet. This optional policy gives game owners control over how players
// can consume available game server resources. A resource creation policy makes
// the following statement: "An individual player can create a maximum number
// of new game sessions within a specified time period".
//
// The policy is evaluated when a player tries to create a new game session.
// For example, with a policy of 10 new game sessions and a time period of 60
// minutes, on receiving a CreateGameSession request, Amazon GameLift checks
// that the player (identified by CreatorId) has created fewer than 10 game
// sessions in the past 60 minutes.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ResourceCreationLimitPolicy
type ResourceCreationLimitPolicy struct {
	_ struct{} `type:"structure"`

	// Maximum number of game sessions that an individual can create during the
	// policy period.
	NewGameSessionsPerCreator *int64 `type:"integer"`

	// Time span used in evaluating the resource creation limit policy.
	PolicyPeriodInMinutes *int64 `type:"integer"`
}

// String returns the string representation
func (s ResourceCreationLimitPolicy) String() string {
	return awsutil.Prettify(s)
}

// Routing configuration for a fleet alias.
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RoutingStrategy
type RoutingStrategy struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet that the alias points to.
	FleetId *string `type:"string"`

	// Message text to be used with a terminal routing strategy.
	Message *string `type:"string"`

	// Type of routing strategy.
	//
	// Possible routing types include the following:
	//
	//    * SIMPLE -- The alias resolves to one specific fleet. Use this type when
	//    routing to active fleets.
	//
	//    * TERMINAL -- The alias does not resolve to a fleet but instead can be
	//    used to display a message to the user. A terminal alias throws a TerminalRoutingStrategyException
	//    with the RoutingStrategy message embedded.
	Type RoutingStrategyType `type:"string" enum:"true"`
}

// String returns the string representation
func (s RoutingStrategy) String() string {
	return awsutil.Prettify(s)
}

// A collection of server process configurations that describe what processes
// to run on each instance in a fleet. Server processes run either a custom
// game build executable or a Realtime Servers script. Each instance in the
// fleet starts the specified server processes and continues to start new processes
// as existing processes end. An instance regularly checks for an updated run-time
// configuration.
//
// The run-time configuration enables the instances in a fleet to run multiple
// processes simultaneously. Learn more about Running Multiple Processes on
// a Fleet (https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html).
//
// A Amazon GameLift instance is limited to 50 processes running simultaneously.
// To calculate the total number of processes in a run-time configuration, add
// the values of the ConcurrentExecutions parameter for each ServerProcess object.
//
//    * CreateFleet
//
//    * ListFleets
//
//    * DeleteFleet
//
//    * Describe fleets: DescribeFleetAttributes DescribeFleetCapacity DescribeFleetPortSettings
//    DescribeFleetUtilization DescribeRuntimeConfiguration DescribeEC2InstanceLimits
//    DescribeFleetEvents
//
//    * Update fleets: UpdateFleetAttributes UpdateFleetCapacity UpdateFleetPortSettings
//    UpdateRuntimeConfiguration
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/RuntimeConfiguration
type RuntimeConfiguration struct {
	_ struct{} `type:"structure"`

	// Maximum amount of time (in seconds) that a game session can remain in status
	// ACTIVATING. If the game session is not active before the timeout, activation
	// is terminated and the game session status is changed to TERMINATED.
	GameSessionActivationTimeoutSeconds *int64 `min:"1" type:"integer"`

	// Maximum number of game sessions with status ACTIVATING to allow on an instance
	// simultaneously. This setting limits the amount of instance resources that
	// can be used for new game activations at any one time.
	MaxConcurrentGameSessionActivations *int64 `min:"1" type:"integer"`

	// Collection of server process configurations that describe which server processes
	// to run on each instance in a fleet.
	ServerProcesses []ServerProcess `min:"1" type:"list"`
}

// String returns the string representation
func (s RuntimeConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuntimeConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RuntimeConfiguration"}
	if s.GameSessionActivationTimeoutSeconds != nil && *s.GameSessionActivationTimeoutSeconds < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("GameSessionActivationTimeoutSeconds", 1))
	}
	if s.MaxConcurrentGameSessionActivations != nil && *s.MaxConcurrentGameSessionActivations < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxConcurrentGameSessionActivations", 1))
	}
	if s.ServerProcesses != nil && len(s.ServerProcesses) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ServerProcesses", 1))
	}
	if s.ServerProcesses != nil {
		for i, v := range s.ServerProcesses {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ServerProcesses", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Location in Amazon Simple Storage Service (Amazon S3) where build or script
// files are stored for access by Amazon GameLift. This location is specified
// in CreateBuild, CreateScript, and UpdateScript requests.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/S3Location
type S3Location struct {
	_ struct{} `type:"structure"`

	// Amazon S3 bucket identifier. This is the name of the S3 bucket.
	Bucket *string `min:"1" type:"string"`

	// Name of the zip file containing the build files or script files.
	Key *string `min:"1" type:"string"`

	// Version of the file, if object versioning is turned on for the bucket. Amazon
	// GameLift uses this information when retrieving files from an S3 bucket that
	// you own. Use this parameter to specify a specific version of the file; if
	// not set, the latest version of the file is retrieved.
	ObjectVersion *string `min:"1" type:"string"`

	// Amazon Resource Name (ARN (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-arn-format.html))
	// for an IAM role that allows Amazon GameLift to access the S3 bucket.
	RoleArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3Location) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Location) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "S3Location"}
	if s.Bucket != nil && len(*s.Bucket) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Bucket", 1))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}
	if s.ObjectVersion != nil && len(*s.ObjectVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ObjectVersion", 1))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("RoleArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Rule that controls how a fleet is scaled. Scaling policies are uniquely identified
// by the combination of name and fleet ID.
//
//    * DescribeFleetCapacity
//
//    * UpdateFleetCapacity
//
//    * DescribeEC2InstanceLimits
//
//    * Manage scaling policies: PutScalingPolicy (auto-scaling) DescribeScalingPolicies
//    (auto-scaling) DeleteScalingPolicy (auto-scaling)
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ScalingPolicy
type ScalingPolicy struct {
	_ struct{} `type:"structure"`

	// Comparison operator to use when measuring a metric against the threshold
	// value.
	ComparisonOperator ComparisonOperatorType `type:"string" enum:"true"`

	// Length of time (in minutes) the metric must be at or beyond the threshold
	// before a scaling event is triggered.
	EvaluationPeriods *int64 `min:"1" type:"integer"`

	// Unique identifier for a fleet that is associated with this scaling policy.
	FleetId *string `type:"string"`

	// Name of the Amazon GameLift-defined metric that is used to trigger a scaling
	// adjustment. For detailed descriptions of fleet metrics, see Monitor Amazon
	// GameLift with Amazon CloudWatch (https://docs.aws.amazon.com/gamelift/latest/developerguide/monitoring-cloudwatch.html).
	//
	//    * ActivatingGameSessions -- Game sessions in the process of being created.
	//
	//    * ActiveGameSessions -- Game sessions that are currently running.
	//
	//    * ActiveInstances -- Fleet instances that are currently running at least
	//    one game session.
	//
	//    * AvailableGameSessions -- Additional game sessions that fleet could host
	//    simultaneously, given current capacity.
	//
	//    * AvailablePlayerSessions -- Empty player slots in currently active game
	//    sessions. This includes game sessions that are not currently accepting
	//    players. Reserved player slots are not included.
	//
	//    * CurrentPlayerSessions -- Player slots in active game sessions that are
	//    being used by a player or are reserved for a player.
	//
	//    * IdleInstances -- Active instances that are currently hosting zero game
	//    sessions.
	//
	//    * PercentAvailableGameSessions -- Unused percentage of the total number
	//    of game sessions that a fleet could host simultaneously, given current
	//    capacity. Use this metric for a target-based scaling policy.
	//
	//    * PercentIdleInstances -- Percentage of the total number of active instances
	//    that are hosting zero game sessions.
	//
	//    * QueueDepth -- Pending game session placement requests, in any queue,
	//    where the current fleet is the top-priority destination.
	//
	//    * WaitTime -- Current wait time for pending game session placement requests,
	//    in any queue, where the current fleet is the top-priority destination.
	MetricName MetricName `type:"string" enum:"true"`

	// Descriptive label that is associated with a scaling policy. Policy names
	// do not need to be unique.
	Name *string `min:"1" type:"string"`

	// Type of scaling policy to create. For a target-based policy, set the parameter
	// MetricName to 'PercentAvailableGameSessions' and specify a TargetConfiguration.
	// For a rule-based policy set the following parameters: MetricName, ComparisonOperator,
	// Threshold, EvaluationPeriods, ScalingAdjustmentType, and ScalingAdjustment.
	PolicyType PolicyType `type:"string" enum:"true"`

	// Amount of adjustment to make, based on the scaling adjustment type.
	ScalingAdjustment *int64 `type:"integer"`

	// Type of adjustment to make to a fleet's instance count (see FleetCapacity):
	//
	//    * ChangeInCapacity -- add (or subtract) the scaling adjustment value from
	//    the current instance count. Positive values scale up while negative values
	//    scale down.
	//
	//    * ExactCapacity -- set the instance count to the scaling adjustment value.
	//
	//    * PercentChangeInCapacity -- increase or reduce the current instance count
	//    by the scaling adjustment, read as a percentage. Positive values scale
	//    up while negative values scale down.
	ScalingAdjustmentType ScalingAdjustmentType `type:"string" enum:"true"`

	// Current status of the scaling policy. The scaling policy can be in force
	// only when in an ACTIVE status. Scaling policies can be suspended for individual
	// fleets (see StopFleetActions; if suspended for a fleet, the policy status
	// does not change. View a fleet's stopped actions by calling DescribeFleetCapacity.
	//
	//    * ACTIVE -- The scaling policy can be used for auto-scaling a fleet.
	//
	//    * UPDATE_REQUESTED -- A request to update the scaling policy has been
	//    received.
	//
	//    * UPDATING -- A change is being made to the scaling policy.
	//
	//    * DELETE_REQUESTED -- A request to delete the scaling policy has been
	//    received.
	//
	//    * DELETING -- The scaling policy is being deleted.
	//
	//    * DELETED -- The scaling policy has been deleted.
	//
	//    * ERROR -- An error occurred in creating the policy. It should be removed
	//    and recreated.
	Status ScalingStatusType `type:"string" enum:"true"`

	// Object that contains settings for a target-based scaling policy.
	TargetConfiguration *TargetConfiguration `type:"structure"`

	// Metric value used to trigger a scaling event.
	Threshold *float64 `type:"double"`
}

// String returns the string representation
func (s ScalingPolicy) String() string {
	return awsutil.Prettify(s)
}

// Properties describing a Realtime script.
//
// Related operations
//
//    * CreateScript
//
//    * ListScripts
//
//    * DescribeScript
//
//    * UpdateScript
//
//    * DeleteScript
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/Script
type Script struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this data object was created. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Descriptive label that is associated with a script. Script names do not need
	// to be unique.
	Name *string `min:"1" type:"string"`

	// Unique identifier for a Realtime script
	ScriptId *string `type:"string"`

	// File size of the uploaded Realtime script, expressed in bytes. When files
	// are uploaded from an S3 location, this value remains at "0".
	SizeOnDisk *int64 `min:"1" type:"long"`

	// Location in Amazon Simple Storage Service (Amazon S3) where build or script
	// files are stored for access by Amazon GameLift. This location is specified
	// in CreateBuild, CreateScript, and UpdateScript requests.
	StorageLocation *S3Location `type:"structure"`

	// Version that is associated with a build or script. Version strings do not
	// need to be unique.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Script) String() string {
	return awsutil.Prettify(s)
}

// A set of instructions for launching server processes on each instance in
// a fleet. Server processes run either a custom game build executable or a
// Realtime Servers script. Each instruction set identifies the location of
// the custom game build executable or Realtime launch script, optional launch
// parameters, and the number of server processes with this configuration to
// maintain concurrently on the instance. Server process configurations make
// up a fleet's RuntimeConfiguration .
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/ServerProcess
type ServerProcess struct {
	_ struct{} `type:"structure"`

	// Number of server processes using this configuration to run concurrently on
	// an instance.
	//
	// ConcurrentExecutions is a required field
	ConcurrentExecutions *int64 `min:"1" type:"integer" required:"true"`

	// Location of the server executable in a custom game build or the name of the
	// Realtime script file that contains the Init() function. Game builds and Realtime
	// scripts are installed on instances at the root:
	//
	//    * Windows (for custom game builds only): C:\game. Example: "C:\game\MyGame\server.exe"
	//
	//    * Linux: /local/game. Examples: "/local/game/MyGame/server.exe" or "/local/game/MyRealtimeScript.js"
	//
	// LaunchPath is a required field
	LaunchPath *string `min:"1" type:"string" required:"true"`

	// Optional list of parameters to pass to the server executable or Realtime
	// script on launch.
	Parameters *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ServerProcess) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServerProcess) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ServerProcess"}

	if s.ConcurrentExecutions == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConcurrentExecutions"))
	}
	if s.ConcurrentExecutions != nil && *s.ConcurrentExecutions < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("ConcurrentExecutions", 1))
	}

	if s.LaunchPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("LaunchPath"))
	}
	if s.LaunchPath != nil && len(*s.LaunchPath) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LaunchPath", 1))
	}
	if s.Parameters != nil && len(*s.Parameters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Parameters", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Settings for a target-based scaling policy (see ScalingPolicy. A target-based
// policy tracks a particular fleet metric specifies a target value for the
// metric. As player usage changes, the policy triggers Amazon GameLift to adjust
// capacity so that the metric returns to the target value. The target configuration
// specifies settings as needed for the target based policy, including the target
// value.
//
//    * DescribeFleetCapacity
//
//    * UpdateFleetCapacity
//
//    * DescribeEC2InstanceLimits
//
//    * Manage scaling policies: PutScalingPolicy (auto-scaling) DescribeScalingPolicies
//    (auto-scaling) DeleteScalingPolicy (auto-scaling)
//
//    * Manage fleet actions: StartFleetActions StopFleetActions
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/TargetConfiguration
type TargetConfiguration struct {
	_ struct{} `type:"structure"`

	// Desired value to use with a target-based scaling policy. The value must be
	// relevant for whatever metric the scaling policy is using. For example, in
	// a policy using the metric PercentAvailableGameSessions, the target value
	// should be the preferred size of the fleet's buffer (the percent of capacity
	// that should be idle and ready for new game sessions).
	//
	// TargetValue is a required field
	TargetValue *float64 `type:"double" required:"true"`
}

// String returns the string representation
func (s TargetConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "TargetConfiguration"}

	if s.TargetValue == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents an authorization for a VPC peering connection between the VPC
// for an Amazon GameLift fleet and another VPC on an account you have access
// to. This authorization must exist and be valid for the peering connection
// to be established. Authorizations are valid for 24 hours after they are issued.
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/VpcPeeringAuthorization
type VpcPeeringAuthorization struct {
	_ struct{} `type:"structure"`

	// Time stamp indicating when this authorization was issued. Format is a number
	// expressed in Unix time as milliseconds (for example "1469498468.057").
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Time stamp indicating when this authorization expires (24 hours after issuance).
	// Format is a number expressed in Unix time as milliseconds (for example "1469498468.057").
	ExpirationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for the AWS account that you use to manage your Amazon
	// GameLift fleet. You can find your Account ID in the AWS Management Console
	// under account settings.
	GameLiftAwsAccountId *string `min:"1" type:"string"`

	PeerVpcAwsAccountId *string `min:"1" type:"string"`

	// Unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same region where your fleet is deployed.
	// Look up a VPC ID using the VPC Dashboard (https://console.aws.amazon.com/vpc/)
	// in the AWS Management Console. Learn more about VPC peering in VPC Peering
	// with Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
	PeerVpcId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s VpcPeeringAuthorization) String() string {
	return awsutil.Prettify(s)
}

// Represents a peering connection between a VPC on one of your AWS accounts
// and the VPC for your Amazon GameLift fleets. This record may be for an active
// peering connection or a pending connection that has not yet been established.
//
//    * CreateVpcPeeringAuthorization
//
//    * DescribeVpcPeeringAuthorizations
//
//    * DeleteVpcPeeringAuthorization
//
//    * CreateVpcPeeringConnection
//
//    * DescribeVpcPeeringConnections
//
//    * DeleteVpcPeeringConnection
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/VpcPeeringConnection
type VpcPeeringConnection struct {
	_ struct{} `type:"structure"`

	// Unique identifier for a fleet. This ID determines the ID of the Amazon GameLift
	// VPC for your fleet.
	FleetId *string `type:"string"`

	// Unique identifier for the VPC that contains the Amazon GameLift fleet for
	// this connection. This VPC is managed by Amazon GameLift and does not appear
	// in your AWS account.
	GameLiftVpcId *string `min:"1" type:"string"`

	// CIDR block of IPv4 addresses assigned to the VPC peering connection for the
	// GameLift VPC. The peered VPC also has an IPv4 CIDR block associated with
	// it; these blocks cannot overlap or the peering connection cannot be created.
	IpV4CidrBlock *string `min:"1" type:"string"`

	// Unique identifier for a VPC with resources to be accessed by your Amazon
	// GameLift fleet. The VPC must be in the same region where your fleet is deployed.
	// Look up a VPC ID using the VPC Dashboard (https://console.aws.amazon.com/vpc/)
	// in the AWS Management Console. Learn more about VPC peering in VPC Peering
	// with Amazon GameLift Fleets (https://docs.aws.amazon.com/gamelift/latest/developerguide/vpc-peering.html).
	PeerVpcId *string `min:"1" type:"string"`

	// Object that contains status information about the connection. Status indicates
	// if a connection is pending, successful, or failed.
	Status *VpcPeeringConnectionStatus `type:"structure"`

	// Unique identifier that is automatically assigned to the connection record.
	// This ID is referenced in VPC peering connection events, and is used when
	// deleting a connection with DeleteVpcPeeringConnection.
	VpcPeeringConnectionId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnection) String() string {
	return awsutil.Prettify(s)
}

// Represents status information for a VPC peering connection. Status is associated
// with a VpcPeeringConnection object. Status codes and messages are provided
// from EC2 (see VpcPeeringConnectionStateReason (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_VpcPeeringConnectionStateReason.html)).
// Connection status information is also communicated as a fleet Event.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/VpcPeeringConnectionStatus
type VpcPeeringConnectionStatus struct {
	_ struct{} `type:"structure"`

	// Code indicating the status of a VPC peering connection.
	Code *string `min:"1" type:"string"`

	// Additional messaging associated with the connection status.
	Message *string `min:"1" type:"string"`
}

// String returns the string representation
func (s VpcPeeringConnectionStatus) String() string {
	return awsutil.Prettify(s)
}
