// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package glue

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlanRequest
type GetPlanInput struct {
	_ struct{} `type:"structure"`

	// The programming language of the code to perform the mapping.
	Language Language `type:"string" enum:"true"`

	// The parameters for the mapping.
	Location *Location `type:"structure"`

	// The list of mappings from a source table to target tables.
	//
	// Mapping is a required field
	Mapping []MappingEntry `type:"list" required:"true"`

	// The target tables.
	Sinks []CatalogEntry `type:"list"`

	// The source table.
	//
	// Source is a required field
	Source *CatalogEntry `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetPlanInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPlanInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetPlanInput"}

	if s.Mapping == nil {
		invalidParams.Add(aws.NewErrParamRequired("Mapping"))
	}

	if s.Source == nil {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(aws.ErrInvalidParams))
		}
	}
	if s.Sinks != nil {
		for i, v := range s.Sinks {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sinks", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlanResponse
type GetPlanOutput struct {
	_ struct{} `type:"structure"`

	// A Python script to perform the mapping.
	PythonScript *string `type:"string"`

	// The Scala code to perform the mapping.
	ScalaCode *string `type:"string"`
}

// String returns the string representation
func (s GetPlanOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetPlan = "GetPlan"

// GetPlanRequest returns a request value for making API operation for
// AWS Glue.
//
// Gets code to perform a specified mapping.
//
//    // Example sending a request using GetPlanRequest.
//    req := client.GetPlanRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/glue-2017-03-31/GetPlan
func (c *Client) GetPlanRequest(input *GetPlanInput) GetPlanRequest {
	op := &aws.Operation{
		Name:       opGetPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPlanInput{}
	}

	req := c.newRequest(op, input, &GetPlanOutput{})
	return GetPlanRequest{Request: req, Input: input, Copy: c.GetPlanRequest}
}

// GetPlanRequest is the request type for the
// GetPlan API operation.
type GetPlanRequest struct {
	*aws.Request
	Input *GetPlanInput
	Copy  func(*GetPlanInput) GetPlanRequest
}

// Send marshals and sends the GetPlan API request.
func (r GetPlanRequest) Send(ctx context.Context) (*GetPlanResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetPlanResponse{
		GetPlanOutput: r.Request.Data.(*GetPlanOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetPlanResponse is the response type for the
// GetPlan API operation.
type GetPlanResponse struct {
	*GetPlanOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetPlan request.
func (r *GetPlanResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
