// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersionRequest
type CreateConnectorDefinitionVersionInput struct {
	_ struct{} `type:"structure"`

	AmznClientToken *string `location:"header" locationName:"X-Amzn-Client-Token" type:"string"`

	// ConnectorDefinitionId is a required field
	ConnectorDefinitionId *string `location:"uri" locationName:"ConnectorDefinitionId" type:"string" required:"true"`

	Connectors []Connector `type:"list"`
}

// String returns the string representation
func (s CreateConnectorDefinitionVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectorDefinitionVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateConnectorDefinitionVersionInput"}

	if s.ConnectorDefinitionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConnectorDefinitionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateConnectorDefinitionVersionInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if len(s.Connectors) > 0 {
		v := s.Connectors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Connectors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.AmznClientToken != nil {
		v := *s.AmznClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "X-Amzn-Client-Token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ConnectorDefinitionId != nil {
		v := *s.ConnectorDefinitionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "ConnectorDefinitionId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersionResponse
type CreateConnectorDefinitionVersionOutput struct {
	_ struct{} `type:"structure"`

	Arn *string `type:"string"`

	CreationTimestamp *string `type:"string"`

	Id *string `type:"string"`

	Version *string `type:"string"`
}

// String returns the string representation
func (s CreateConnectorDefinitionVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateConnectorDefinitionVersionOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTimestamp != nil {
		v := *s.CreationTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateConnectorDefinitionVersion = "CreateConnectorDefinitionVersion"

// CreateConnectorDefinitionVersionRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Creates a version of a connector definition which has already been defined.
//
//    // Example sending a request using CreateConnectorDefinitionVersionRequest.
//    req := client.CreateConnectorDefinitionVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CreateConnectorDefinitionVersion
func (c *Client) CreateConnectorDefinitionVersionRequest(input *CreateConnectorDefinitionVersionInput) CreateConnectorDefinitionVersionRequest {
	op := &aws.Operation{
		Name:       opCreateConnectorDefinitionVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/greengrass/definition/connectors/{ConnectorDefinitionId}/versions",
	}

	if input == nil {
		input = &CreateConnectorDefinitionVersionInput{}
	}

	req := c.newRequest(op, input, &CreateConnectorDefinitionVersionOutput{})
	return CreateConnectorDefinitionVersionRequest{Request: req, Input: input, Copy: c.CreateConnectorDefinitionVersionRequest}
}

// CreateConnectorDefinitionVersionRequest is the request type for the
// CreateConnectorDefinitionVersion API operation.
type CreateConnectorDefinitionVersionRequest struct {
	*aws.Request
	Input *CreateConnectorDefinitionVersionInput
	Copy  func(*CreateConnectorDefinitionVersionInput) CreateConnectorDefinitionVersionRequest
}

// Send marshals and sends the CreateConnectorDefinitionVersion API request.
func (r CreateConnectorDefinitionVersionRequest) Send(ctx context.Context) (*CreateConnectorDefinitionVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConnectorDefinitionVersionResponse{
		CreateConnectorDefinitionVersionOutput: r.Request.Data.(*CreateConnectorDefinitionVersionOutput),
		response:                               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConnectorDefinitionVersionResponse is the response type for the
// CreateConnectorDefinitionVersion API operation.
type CreateConnectorDefinitionVersionResponse struct {
	*CreateConnectorDefinitionVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConnectorDefinitionVersion request.
func (r *CreateConnectorDefinitionVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
