// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfigurationRequest
type UpdateGroupCertificateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The amount of time remaining before the certificate expires, in milliseconds.
	CertificateExpiryInMilliseconds *string `type:"string"`

	// GroupId is a required field
	GroupId *string `location:"uri" locationName:"GroupId" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateGroupCertificateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupCertificateConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateGroupCertificateConfigurationInput"}

	if s.GroupId == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGroupCertificateConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.CertificateExpiryInMilliseconds != nil {
		v := *s.CertificateExpiryInMilliseconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CertificateExpiryInMilliseconds", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "GroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfigurationResponse
type UpdateGroupCertificateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	CertificateAuthorityExpiryInMilliseconds *string `type:"string"`

	CertificateExpiryInMilliseconds *string `type:"string"`

	GroupId *string `type:"string"`
}

// String returns the string representation
func (s UpdateGroupCertificateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateGroupCertificateConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateAuthorityExpiryInMilliseconds != nil {
		v := *s.CertificateAuthorityExpiryInMilliseconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CertificateAuthorityExpiryInMilliseconds", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CertificateExpiryInMilliseconds != nil {
		v := *s.CertificateExpiryInMilliseconds

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CertificateExpiryInMilliseconds", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opUpdateGroupCertificateConfiguration = "UpdateGroupCertificateConfiguration"

// UpdateGroupCertificateConfigurationRequest returns a request value for making API operation for
// AWS Greengrass.
//
// Updates the Certificate expiry time for a group.
//
//    // Example sending a request using UpdateGroupCertificateConfigurationRequest.
//    req := client.UpdateGroupCertificateConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/UpdateGroupCertificateConfiguration
func (c *Client) UpdateGroupCertificateConfigurationRequest(input *UpdateGroupCertificateConfigurationInput) UpdateGroupCertificateConfigurationRequest {
	op := &aws.Operation{
		Name:       opUpdateGroupCertificateConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/greengrass/groups/{GroupId}/certificateauthorities/configuration/expiry",
	}

	if input == nil {
		input = &UpdateGroupCertificateConfigurationInput{}
	}

	req := c.newRequest(op, input, &UpdateGroupCertificateConfigurationOutput{})
	return UpdateGroupCertificateConfigurationRequest{Request: req, Input: input, Copy: c.UpdateGroupCertificateConfigurationRequest}
}

// UpdateGroupCertificateConfigurationRequest is the request type for the
// UpdateGroupCertificateConfiguration API operation.
type UpdateGroupCertificateConfigurationRequest struct {
	*aws.Request
	Input *UpdateGroupCertificateConfigurationInput
	Copy  func(*UpdateGroupCertificateConfigurationInput) UpdateGroupCertificateConfigurationRequest
}

// Send marshals and sends the UpdateGroupCertificateConfiguration API request.
func (r UpdateGroupCertificateConfigurationRequest) Send(ctx context.Context) (*UpdateGroupCertificateConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateGroupCertificateConfigurationResponse{
		UpdateGroupCertificateConfigurationOutput: r.Request.Data.(*UpdateGroupCertificateConfigurationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateGroupCertificateConfigurationResponse is the response type for the
// UpdateGroupCertificateConfiguration API operation.
type UpdateGroupCertificateConfigurationResponse struct {
	*UpdateGroupCertificateConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateGroupCertificateConfiguration request.
func (r *UpdateGroupCertificateConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
