// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package greengrass

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// Information about a bulk deployment. You cannot start a new bulk deployment
// while another one is still running or in a non-terminal state.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/BulkDeployment
type BulkDeployment struct {
	_ struct{} `type:"structure"`

	// The ARN of the bulk deployment.
	BulkDeploymentArn *string `type:"string"`

	// The ID of the bulk deployment.
	BulkDeploymentId *string `type:"string"`

	// The time, in ISO format, when the deployment was created.
	CreatedAt *string `type:"string"`
}

// String returns the string representation
func (s BulkDeployment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BulkDeployment) MarshalFields(e protocol.FieldEncoder) error {
	if s.BulkDeploymentArn != nil {
		v := *s.BulkDeploymentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BulkDeploymentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.BulkDeploymentId != nil {
		v := *s.BulkDeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "BulkDeploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Relevant metrics on input records processed during bulk deployment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/BulkDeploymentMetrics
type BulkDeploymentMetrics struct {
	_ struct{} `type:"structure"`

	// The total number of records that returned a non-retryable error. For example,
	// this can occur if a group record from the input file uses an invalid format
	// or specifies a nonexistent group version, or if the execution role doesn't
	// grant permission to deploy a group or group version.
	InvalidInputRecords *int64 `type:"integer"`

	// The total number of group records from the input file that have been processed
	// so far, or attempted.
	RecordsProcessed *int64 `type:"integer"`

	// The total number of deployment attempts that returned a retryable error.
	// For example, a retry is triggered if the attempt to deploy a group returns
	// a throttling error. ''StartBulkDeployment'' retries a group deployment up
	// to five times.
	RetryAttempts *int64 `type:"integer"`
}

// String returns the string representation
func (s BulkDeploymentMetrics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BulkDeploymentMetrics) MarshalFields(e protocol.FieldEncoder) error {
	if s.InvalidInputRecords != nil {
		v := *s.InvalidInputRecords

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InvalidInputRecords", protocol.Int64Value(v), metadata)
	}
	if s.RecordsProcessed != nil {
		v := *s.RecordsProcessed

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RecordsProcessed", protocol.Int64Value(v), metadata)
	}
	if s.RetryAttempts != nil {
		v := *s.RetryAttempts

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "RetryAttempts", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about an individual group deployment in a bulk deployment operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/BulkDeploymentResult
type BulkDeploymentResult struct {
	_ struct{} `type:"structure"`

	// The time, in ISO format, when the deployment was created.
	CreatedAt *string `type:"string"`

	// The ARN of the group deployment.
	DeploymentArn *string `type:"string"`

	// The ID of the group deployment.
	DeploymentId *string `type:"string"`

	// The current status of the group deployment: ''InProgress'', ''Building'',
	// ''Success'', or ''Failure''.
	DeploymentStatus *string `type:"string"`

	// The type of the deployment.
	DeploymentType DeploymentType `type:"string" enum:"true"`

	// Details about the error.
	ErrorDetails []ErrorDetail `type:"list"`

	// The error message for a failed deployment
	ErrorMessage *string `type:"string"`

	// The ARN of the Greengrass group.
	GroupArn *string `type:"string"`
}

// String returns the string representation
func (s BulkDeploymentResult) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s BulkDeploymentResult) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentArn != nil {
		v := *s.DeploymentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentStatus != nil {
		v := *s.DeploymentStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DeploymentType) > 0 {
		v := s.DeploymentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if len(s.ErrorDetails) > 0 {
		v := s.ErrorDetails

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ErrorDetails", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ErrorMessage != nil {
		v := *s.ErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupArn != nil {
		v := *s.GroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a Greengrass core's connectivity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ConnectivityInfo
type ConnectivityInfo struct {
	_ struct{} `type:"structure"`

	// The endpoint for the Greengrass core. Can be an IP address or DNS.
	HostAddress *string `type:"string"`

	// The ID of the connectivity information.
	Id *string `type:"string"`

	// Metadata for this endpoint.
	Metadata *string `type:"string"`

	// The port of the Greengrass core. Usually 8883.
	PortNumber *int64 `type:"integer"`
}

// String returns the string representation
func (s ConnectivityInfo) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConnectivityInfo) MarshalFields(e protocol.FieldEncoder) error {
	if s.HostAddress != nil {
		v := *s.HostAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "HostAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Metadata != nil {
		v := *s.Metadata

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Metadata", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PortNumber != nil {
		v := *s.PortNumber

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "PortNumber", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about a connector. Connectors run on the Greengrass core and
// contain built-in integration with local infrastructure, device protocols,
// AWS, and other cloud services.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Connector
type Connector struct {
	_ struct{} `type:"structure"`

	// The ARN of the connector.
	ConnectorArn *string `type:"string"`

	// A descriptive or arbitrary ID for the connector. This value must be unique
	// within the connector definition version. Max length is 128 characters with
	// pattern [a-zA-Z0-9:_-]+.
	Id *string `type:"string"`

	// The parameters or configuration that the connector uses.
	Parameters map[string]string `type:"map"`
}

// String returns the string representation
func (s Connector) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Connector) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectorArn != nil {
		v := *s.ConnectorArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectorArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Parameters) > 0 {
		v := s.Parameters

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Parameters", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Information about the connector definition version, which is a container
// for connectors.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ConnectorDefinitionVersion
type ConnectorDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of references to connectors in this version, with their corresponding
	// configuration settings.
	Connectors []Connector `type:"list"`
}

// String returns the string representation
func (s ConnectorDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ConnectorDefinitionVersion) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Connectors) > 0 {
		v := s.Connectors

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Connectors", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about a core.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Core
type Core struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate associated with the core.
	CertificateArn *string `type:"string"`

	// A descriptive or arbitrary ID for the core. This value must be unique within
	// the core definition version. Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''.
	Id *string `type:"string"`

	// If true, the core's local shadow is automatically synced with the cloud.
	SyncShadow *bool `type:"boolean"`

	// The ARN of the thing which is the core.
	ThingArn *string `type:"string"`
}

// String returns the string representation
func (s Core) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Core) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CertificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SyncShadow != nil {
		v := *s.SyncShadow

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SyncShadow", protocol.BoolValue(v), metadata)
	}
	if s.ThingArn != nil {
		v := *s.ThingArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThingArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a core definition version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/CoreDefinitionVersion
type CoreDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of cores in the core definition version.
	Cores []Core `type:"list"`
}

// String returns the string representation
func (s CoreDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CoreDefinitionVersion) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Cores) > 0 {
		v := s.Cores

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Cores", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about a definition.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DefinitionInformation
type DefinitionInformation struct {
	_ struct{} `type:"structure"`

	// The ARN of the definition.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the definition was created.
	CreationTimestamp *string `type:"string"`

	// The ID of the definition.
	Id *string `type:"string"`

	// The time, in milliseconds since the epoch, when the definition was last updated.
	LastUpdatedTimestamp *string `type:"string"`

	// The latest version of the definition.
	LatestVersion *string `type:"string"`

	// The ARN of the latest version of the definition.
	LatestVersionArn *string `type:"string"`

	// The name of the definition.
	Name *string `type:"string"`

	Tags map[string]string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DefinitionInformation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DefinitionInformation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTimestamp != nil {
		v := *s.CreationTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedTimestamp != nil {
		v := *s.LastUpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LatestVersion != nil {
		v := *s.LatestVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LatestVersionArn != nil {
		v := *s.LatestVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "tags", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// Information about a deployment.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Deployment
type Deployment struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds since the epoch, when the deployment was created.
	CreatedAt *string `type:"string"`

	// The ARN of the deployment.
	DeploymentArn *string `type:"string"`

	// The ID of the deployment.
	DeploymentId *string `type:"string"`

	// The type of the deployment.
	DeploymentType DeploymentType `type:"string" enum:"true"`

	// The ARN of the group for this deployment.
	GroupArn *string `type:"string"`
}

// String returns the string representation
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Deployment) MarshalFields(e protocol.FieldEncoder) error {
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentArn != nil {
		v := *s.DeploymentArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeploymentId != nil {
		v := *s.DeploymentId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.DeploymentType) > 0 {
		v := s.DeploymentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeploymentType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.GroupArn != nil {
		v := *s.GroupArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a device.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Device
type Device struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate associated with the device.
	CertificateArn *string `type:"string"`

	// A descriptive or arbitrary ID for the device. This value must be unique within
	// the device definition version. Max length is 128 characters with pattern
	// ''[a-zA-Z0-9:_-]+''.
	Id *string `type:"string"`

	// If true, the device's local shadow will be automatically synced with the
	// cloud.
	SyncShadow *bool `type:"boolean"`

	// The thing ARN of the device.
	ThingArn *string `type:"string"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Device) MarshalFields(e protocol.FieldEncoder) error {
	if s.CertificateArn != nil {
		v := *s.CertificateArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CertificateArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SyncShadow != nil {
		v := *s.SyncShadow

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SyncShadow", protocol.BoolValue(v), metadata)
	}
	if s.ThingArn != nil {
		v := *s.ThingArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ThingArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a device definition version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/DeviceDefinitionVersion
type DeviceDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of devices in the definition version.
	Devices []Device `type:"list"`
}

// String returns the string representation
func (s DeviceDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeviceDefinitionVersion) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Devices) > 0 {
		v := s.Devices

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Devices", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Details about the error.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ErrorDetail
type ErrorDetail struct {
	_ struct{} `type:"structure"`

	// A detailed error code.
	DetailedErrorCode *string `type:"string"`

	// A detailed error message.
	DetailedErrorMessage *string `type:"string"`
}

// String returns the string representation
func (s ErrorDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ErrorDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.DetailedErrorCode != nil {
		v := *s.DetailedErrorCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DetailedErrorCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetailedErrorMessage != nil {
		v := *s.DetailedErrorMessage

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DetailedErrorMessage", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Function
type Function struct {
	_ struct{} `type:"structure"`

	// The ARN of the Lambda function.
	FunctionArn *string `type:"string"`

	// The configuration of the Lambda function.
	FunctionConfiguration *FunctionConfiguration `type:"structure"`

	// A descriptive or arbitrary ID for the function. This value must be unique
	// within the function definition version. Max length is 128 characters with
	// pattern ''[a-zA-Z0-9:_-]+''.
	Id *string `type:"string"`
}

// String returns the string representation
func (s Function) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Function) MarshalFields(e protocol.FieldEncoder) error {
	if s.FunctionArn != nil {
		v := *s.FunctionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionConfiguration != nil {
		v := s.FunctionConfiguration

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "FunctionConfiguration", v, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The configuration of the Lambda function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionConfiguration
type FunctionConfiguration struct {
	_ struct{} `type:"structure"`

	// The expected encoding type of the input payload for the function. The default
	// is ''json''.
	EncodingType EncodingType `type:"string" enum:"true"`

	// The environment configuration of the function.
	Environment *FunctionConfigurationEnvironment `type:"structure"`

	// The execution arguments.
	ExecArgs *string `type:"string"`

	// The name of the function executable.
	Executable *string `type:"string"`

	// The memory size, in KB, which the function requires. This setting is not
	// applicable and should be cleared when you run the Lambda function without
	// containerization.
	MemorySize *int64 `type:"integer"`

	// True if the function is pinned. Pinned means the function is long-lived and
	// starts when the core starts.
	Pinned *bool `type:"boolean"`

	// The allowed function execution time, after which Lambda should terminate
	// the function. This timeout still applies to pinned Lambda functions for each
	// request.
	Timeout *int64 `type:"integer"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionConfiguration) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.EncodingType) > 0 {
		v := s.EncodingType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "EncodingType", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Environment != nil {
		v := s.Environment

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Environment", v, metadata)
	}
	if s.ExecArgs != nil {
		v := *s.ExecArgs

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExecArgs", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Executable != nil {
		v := *s.Executable

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Executable", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MemorySize != nil {
		v := *s.MemorySize

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MemorySize", protocol.Int64Value(v), metadata)
	}
	if s.Pinned != nil {
		v := *s.Pinned

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Pinned", protocol.BoolValue(v), metadata)
	}
	if s.Timeout != nil {
		v := *s.Timeout

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Timeout", protocol.Int64Value(v), metadata)
	}
	return nil
}

// The environment configuration of the function.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionConfigurationEnvironment
type FunctionConfigurationEnvironment struct {
	_ struct{} `type:"structure"`

	// If true, the Lambda function is allowed to access the host's /sys folder.
	// Use this when the Lambda function needs to read device information from /sys.
	// This setting applies only when you run the Lambda function in a Greengrass
	// container.
	AccessSysfs *bool `type:"boolean"`

	// Configuration related to executing the Lambda function
	Execution *FunctionExecutionConfig `type:"structure"`

	// A list of the resources, with their permissions, to which the Lambda function
	// will be granted access. A Lambda function can have at most 10 resources.
	// ResourceAccessPolicies apply only when you run the Lambda function in a Greengrass
	// container.
	ResourceAccessPolicies []ResourceAccessPolicy `type:"list"`

	// Environment variables for the Lambda function's configuration.
	Variables map[string]string `type:"map"`
}

// String returns the string representation
func (s FunctionConfigurationEnvironment) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionConfigurationEnvironment) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessSysfs != nil {
		v := *s.AccessSysfs

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AccessSysfs", protocol.BoolValue(v), metadata)
	}
	if s.Execution != nil {
		v := s.Execution

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Execution", v, metadata)
	}
	if len(s.ResourceAccessPolicies) > 0 {
		v := s.ResourceAccessPolicies

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ResourceAccessPolicies", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Variables) > 0 {
		v := s.Variables

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "Variables", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ms0.End()

	}
	return nil
}

// The default configuration that applies to all Lambda functions in the group.
// Individual Lambda functions can override these settings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionDefaultConfig
type FunctionDefaultConfig struct {
	_ struct{} `type:"structure"`

	// Configuration information that specifies how a Lambda function runs.
	Execution *FunctionDefaultExecutionConfig `type:"structure"`
}

// String returns the string representation
func (s FunctionDefaultConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionDefaultConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Execution != nil {
		v := s.Execution

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Execution", v, metadata)
	}
	return nil
}

// Configuration information that specifies how a Lambda function runs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionDefaultExecutionConfig
type FunctionDefaultExecutionConfig struct {
	_ struct{} `type:"structure"`

	// Specifies whether the Lambda function runs in a Greengrass container (default)
	// or without containerization. Unless your scenario requires that you run without
	// containerization, we recommend that you run in a Greengrass container. Omit
	// this value to run the Lambda function with the default containerization for
	// the group.
	IsolationMode FunctionIsolationMode `type:"string" enum:"true"`

	// Specifies the user and group whose permissions are used when running the
	// Lambda function. You can specify one or both values to override the default
	// values. We recommend that you avoid running as root unless absolutely necessary
	// to minimize the risk of unintended changes or malicious attacks. To run as
	// root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json
	// in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
	RunAs *FunctionRunAsConfig `type:"structure"`
}

// String returns the string representation
func (s FunctionDefaultExecutionConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionDefaultExecutionConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.IsolationMode) > 0 {
		v := s.IsolationMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsolationMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RunAs != nil {
		v := s.RunAs

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RunAs", v, metadata)
	}
	return nil
}

// Information about a function definition version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionDefinitionVersion
type FunctionDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// The default configuration that applies to all Lambda functions in this function
	// definition version. Individual Lambda functions can override these settings.
	DefaultConfig *FunctionDefaultConfig `type:"structure"`

	// A list of Lambda functions in this function definition version.
	Functions []Function `type:"list"`
}

// String returns the string representation
func (s FunctionDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionDefinitionVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.DefaultConfig != nil {
		v := s.DefaultConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "DefaultConfig", v, metadata)
	}
	if len(s.Functions) > 0 {
		v := s.Functions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Functions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Configuration information that specifies how a Lambda function runs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionExecutionConfig
type FunctionExecutionConfig struct {
	_ struct{} `type:"structure"`

	// Specifies whether the Lambda function runs in a Greengrass container (default)
	// or without containerization. Unless your scenario requires that you run without
	// containerization, we recommend that you run in a Greengrass container. Omit
	// this value to run the Lambda function with the default containerization for
	// the group.
	IsolationMode FunctionIsolationMode `type:"string" enum:"true"`

	// Specifies the user and group whose permissions are used when running the
	// Lambda function. You can specify one or both values to override the default
	// values. We recommend that you avoid running as root unless absolutely necessary
	// to minimize the risk of unintended changes or malicious attacks. To run as
	// root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json
	// in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
	RunAs *FunctionRunAsConfig `type:"structure"`
}

// String returns the string representation
func (s FunctionExecutionConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionExecutionConfig) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.IsolationMode) > 0 {
		v := s.IsolationMode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "IsolationMode", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.RunAs != nil {
		v := s.RunAs

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "RunAs", v, metadata)
	}
	return nil
}

// Specifies the user and group whose permissions are used when running the
// Lambda function. You can specify one or both values to override the default
// values. We recommend that you avoid running as root unless absolutely necessary
// to minimize the risk of unintended changes or malicious attacks. To run as
// root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json
// in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/FunctionRunAsConfig
type FunctionRunAsConfig struct {
	_ struct{} `type:"structure"`

	// The group ID whose permissions are used to run a Lambda function.
	Gid *int64 `type:"integer"`

	// The user ID whose permissions are used to run a Lambda function.
	Uid *int64 `type:"integer"`
}

// String returns the string representation
func (s FunctionRunAsConfig) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FunctionRunAsConfig) MarshalFields(e protocol.FieldEncoder) error {
	if s.Gid != nil {
		v := *s.Gid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Gid", protocol.Int64Value(v), metadata)
	}
	if s.Uid != nil {
		v := *s.Uid

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Uid", protocol.Int64Value(v), metadata)
	}
	return nil
}

// Information about a certificate authority for a group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GroupCertificateAuthorityProperties
type GroupCertificateAuthorityProperties struct {
	_ struct{} `type:"structure"`

	// The ARN of the certificate authority for the group.
	GroupCertificateAuthorityArn *string `type:"string"`

	// The ID of the certificate authority for the group.
	GroupCertificateAuthorityId *string `type:"string"`
}

// String returns the string representation
func (s GroupCertificateAuthorityProperties) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupCertificateAuthorityProperties) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupCertificateAuthorityArn != nil {
		v := *s.GroupCertificateAuthorityArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupCertificateAuthorityArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupCertificateAuthorityId != nil {
		v := *s.GroupCertificateAuthorityId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupCertificateAuthorityId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a group.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GroupInformation
type GroupInformation struct {
	_ struct{} `type:"structure"`

	// The ARN of the group.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the group was created.
	CreationTimestamp *string `type:"string"`

	// The ID of the group.
	Id *string `type:"string"`

	// The time, in milliseconds since the epoch, when the group was last updated.
	LastUpdatedTimestamp *string `type:"string"`

	// The latest version of the group.
	LatestVersion *string `type:"string"`

	// The ARN of the latest version of the group.
	LatestVersionArn *string `type:"string"`

	// The name of the group.
	Name *string `type:"string"`
}

// String returns the string representation
func (s GroupInformation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupInformation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTimestamp != nil {
		v := *s.CreationTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LastUpdatedTimestamp != nil {
		v := *s.LastUpdatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LastUpdatedTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LatestVersion != nil {
		v := *s.LatestVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LatestVersionArn != nil {
		v := *s.LatestVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LatestVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Group owner related settings for local resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GroupOwnerSetting
type GroupOwnerSetting struct {
	_ struct{} `type:"structure"`

	// If true, AWS IoT Greengrass automatically adds the specified Linux OS group
	// owner of the resource to the Lambda process privileges. Thus the Lambda process
	// will have the file access permissions of the added Linux group.
	AutoAddGroupOwner *bool `type:"boolean"`

	// The name of the Linux OS group whose privileges will be added to the Lambda
	// process. This field is optional.
	GroupOwner *string `type:"string"`
}

// String returns the string representation
func (s GroupOwnerSetting) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupOwnerSetting) MarshalFields(e protocol.FieldEncoder) error {
	if s.AutoAddGroupOwner != nil {
		v := *s.AutoAddGroupOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "AutoAddGroupOwner", protocol.BoolValue(v), metadata)
	}
	if s.GroupOwner != nil {
		v := *s.GroupOwner

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupOwner", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a group version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/GroupVersion
type GroupVersion struct {
	_ struct{} `type:"structure"`

	// The ARN of the connector definition version for this group.
	ConnectorDefinitionVersionArn *string `type:"string"`

	// The ARN of the core definition version for this group.
	CoreDefinitionVersionArn *string `type:"string"`

	// The ARN of the device definition version for this group.
	DeviceDefinitionVersionArn *string `type:"string"`

	// The ARN of the function definition version for this group.
	FunctionDefinitionVersionArn *string `type:"string"`

	// The ARN of the logger definition version for this group.
	LoggerDefinitionVersionArn *string `type:"string"`

	// The ARN of the resource definition version for this group.
	ResourceDefinitionVersionArn *string `type:"string"`

	// The ARN of the subscription definition version for this group.
	SubscriptionDefinitionVersionArn *string `type:"string"`
}

// String returns the string representation
func (s GroupVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GroupVersion) MarshalFields(e protocol.FieldEncoder) error {
	if s.ConnectorDefinitionVersionArn != nil {
		v := *s.ConnectorDefinitionVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ConnectorDefinitionVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CoreDefinitionVersionArn != nil {
		v := *s.CoreDefinitionVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CoreDefinitionVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DeviceDefinitionVersionArn != nil {
		v := *s.DeviceDefinitionVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DeviceDefinitionVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.FunctionDefinitionVersionArn != nil {
		v := *s.FunctionDefinitionVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "FunctionDefinitionVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LoggerDefinitionVersionArn != nil {
		v := *s.LoggerDefinitionVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "LoggerDefinitionVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceDefinitionVersionArn != nil {
		v := *s.ResourceDefinitionVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceDefinitionVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SubscriptionDefinitionVersionArn != nil {
		v := *s.SubscriptionDefinitionVersionArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SubscriptionDefinitionVersionArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes that define a local device resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/LocalDeviceResourceData
type LocalDeviceResourceData struct {
	_ struct{} `type:"structure"`

	// Group/owner related settings for local resources.
	GroupOwnerSetting *GroupOwnerSetting `type:"structure"`

	// The local absolute path of the device resource. The source path for a device
	// resource can refer only to a character device or block device under ''/dev''.
	SourcePath *string `type:"string"`
}

// String returns the string representation
func (s LocalDeviceResourceData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LocalDeviceResourceData) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupOwnerSetting != nil {
		v := s.GroupOwnerSetting

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GroupOwnerSetting", v, metadata)
	}
	if s.SourcePath != nil {
		v := *s.SourcePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourcePath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes that define a local volume resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/LocalVolumeResourceData
type LocalVolumeResourceData struct {
	_ struct{} `type:"structure"`

	// The absolute local path of the resource inside the Lambda environment.
	DestinationPath *string `type:"string"`

	// Allows you to configure additional group privileges for the Lambda process.
	// This field is optional.
	GroupOwnerSetting *GroupOwnerSetting `type:"structure"`

	// The local absolute path of the volume resource on the host. The source path
	// for a volume resource type cannot start with ''/sys''.
	SourcePath *string `type:"string"`
}

// String returns the string representation
func (s LocalVolumeResourceData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LocalVolumeResourceData) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationPath != nil {
		v := *s.DestinationPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupOwnerSetting != nil {
		v := s.GroupOwnerSetting

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "GroupOwnerSetting", v, metadata)
	}
	if s.SourcePath != nil {
		v := *s.SourcePath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SourcePath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a logger
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Logger
type Logger struct {
	_ struct{} `type:"structure"`

	// The component that will be subject to logging.
	Component LoggerComponent `type:"string" enum:"true"`

	// A descriptive or arbitrary ID for the logger. This value must be unique within
	// the logger definition version. Max length is 128 characters with pattern
	// ''[a-zA-Z0-9:_-]+''.
	Id *string `type:"string"`

	// The level of the logs.
	Level LoggerLevel `type:"string" enum:"true"`

	// The amount of file space, in KB, to use if the local file system is used
	// for logging purposes.
	Space *int64 `type:"integer"`

	// The type of log output which will be used.
	Type LoggerType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Logger) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Logger) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Component) > 0 {
		v := s.Component

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Component", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Level) > 0 {
		v := s.Level

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Level", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Space != nil {
		v := *s.Space

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Space", protocol.Int64Value(v), metadata)
	}
	if len(s.Type) > 0 {
		v := s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Type", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// Information about a logger definition version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/LoggerDefinitionVersion
type LoggerDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of loggers.
	Loggers []Logger `type:"list"`
}

// String returns the string representation
func (s LoggerDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LoggerDefinitionVersion) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Loggers) > 0 {
		v := s.Loggers

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Loggers", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Resource
type Resource struct {
	_ struct{} `type:"structure"`

	// The resource ID, used to refer to a resource in the Lambda function configuration.
	// Max length is 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This must
	// be unique within a Greengrass group.
	Id *string `type:"string"`

	// The descriptive resource name, which is displayed on the AWS IoT Greengrass
	// console. Max length 128 characters with pattern ''[a-zA-Z0-9:_-]+''. This
	// must be unique within a Greengrass group.
	Name *string `type:"string"`

	// A container of data for all resource types.
	ResourceDataContainer *ResourceDataContainer `type:"structure"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resource) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceDataContainer != nil {
		v := s.ResourceDataContainer

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "ResourceDataContainer", v, metadata)
	}
	return nil
}

// A policy used by the function to access a resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResourceAccessPolicy
type ResourceAccessPolicy struct {
	_ struct{} `type:"structure"`

	// The permissions that the Lambda function has to the resource. Can be one
	// of ''rw'' (read/write) or ''ro'' (read-only).
	Permission Permission `type:"string" enum:"true"`

	// The ID of the resource. (This ID is assigned to the resource when you create
	// the resource definiton.)
	ResourceId *string `type:"string"`
}

// String returns the string representation
func (s ResourceAccessPolicy) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceAccessPolicy) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Permission) > 0 {
		v := s.Permission

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Permission", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.ResourceId != nil {
		v := *s.ResourceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ResourceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// A container for resource data. The container takes only one of the following
// supported resource data types: ''LocalDeviceResourceData'', ''LocalVolumeResourceData'',
// ''SageMakerMachineLearningModelResourceData'', ''S3MachineLearningModelResourceData'',
// ''SecretsManagerSecretResourceData''.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResourceDataContainer
type ResourceDataContainer struct {
	_ struct{} `type:"structure"`

	// Attributes that define the local device resource.
	LocalDeviceResourceData *LocalDeviceResourceData `type:"structure"`

	// Attributes that define the local volume resource.
	LocalVolumeResourceData *LocalVolumeResourceData `type:"structure"`

	// Attributes that define an Amazon S3 machine learning resource.
	S3MachineLearningModelResourceData *S3MachineLearningModelResourceData `type:"structure"`

	// Attributes that define an Amazon SageMaker machine learning resource.
	SageMakerMachineLearningModelResourceData *SageMakerMachineLearningModelResourceData `type:"structure"`

	// Attributes that define a secret resource, which references a secret from
	// AWS Secrets Manager.
	SecretsManagerSecretResourceData *SecretsManagerSecretResourceData `type:"structure"`
}

// String returns the string representation
func (s ResourceDataContainer) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceDataContainer) MarshalFields(e protocol.FieldEncoder) error {
	if s.LocalDeviceResourceData != nil {
		v := s.LocalDeviceResourceData

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LocalDeviceResourceData", v, metadata)
	}
	if s.LocalVolumeResourceData != nil {
		v := s.LocalVolumeResourceData

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "LocalVolumeResourceData", v, metadata)
	}
	if s.S3MachineLearningModelResourceData != nil {
		v := s.S3MachineLearningModelResourceData

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "S3MachineLearningModelResourceData", v, metadata)
	}
	if s.SageMakerMachineLearningModelResourceData != nil {
		v := s.SageMakerMachineLearningModelResourceData

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SageMakerMachineLearningModelResourceData", v, metadata)
	}
	if s.SecretsManagerSecretResourceData != nil {
		v := s.SecretsManagerSecretResourceData

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "SecretsManagerSecretResourceData", v, metadata)
	}
	return nil
}

// Information about a resource definition version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/ResourceDefinitionVersion
type ResourceDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of resources.
	Resources []Resource `type:"list"`
}

// String returns the string representation
func (s ResourceDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ResourceDefinitionVersion) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Resources) > 0 {
		v := s.Resources

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Resources", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Attributes that define an Amazon S3 machine learning resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/S3MachineLearningModelResourceData
type S3MachineLearningModelResourceData struct {
	_ struct{} `type:"structure"`

	// The absolute local path of the resource inside the Lambda environment.
	DestinationPath *string `type:"string"`

	// The URI of the source model in an S3 bucket. The model package must be in
	// tar.gz or .zip format.
	S3Uri *string `type:"string"`
}

// String returns the string representation
func (s S3MachineLearningModelResourceData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s S3MachineLearningModelResourceData) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationPath != nil {
		v := *s.DestinationPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.S3Uri != nil {
		v := *s.S3Uri

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "S3Uri", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes that define an Amazon SageMaker machine learning resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/SageMakerMachineLearningModelResourceData
type SageMakerMachineLearningModelResourceData struct {
	_ struct{} `type:"structure"`

	// The absolute local path of the resource inside the Lambda environment.
	DestinationPath *string `type:"string"`

	// The ARN of the Amazon SageMaker training job that represents the source model.
	SageMakerJobArn *string `type:"string"`
}

// String returns the string representation
func (s SageMakerMachineLearningModelResourceData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SageMakerMachineLearningModelResourceData) MarshalFields(e protocol.FieldEncoder) error {
	if s.DestinationPath != nil {
		v := *s.DestinationPath

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DestinationPath", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SageMakerJobArn != nil {
		v := *s.SageMakerJobArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SageMakerJobArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Attributes that define a secret resource, which references a secret from
// AWS Secrets Manager. AWS IoT Greengrass stores a local, encrypted copy of
// the secret on the Greengrass core, where it can be securely accessed by connectors
// and Lambda functions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/SecretsManagerSecretResourceData
type SecretsManagerSecretResourceData struct {
	_ struct{} `type:"structure"`

	// The ARN of the Secrets Manager secret to make available on the core. The
	// value of the secret's latest version (represented by the ''AWSCURRENT'' staging
	// label) is included by default.
	ARN *string `type:"string"`

	// Optional. The staging labels whose values you want to make available on the
	// core, in addition to ''AWSCURRENT''.
	AdditionalStagingLabelsToDownload []string `type:"list"`
}

// String returns the string representation
func (s SecretsManagerSecretResourceData) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecretsManagerSecretResourceData) MarshalFields(e protocol.FieldEncoder) error {
	if s.ARN != nil {
		v := *s.ARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.AdditionalStagingLabelsToDownload) > 0 {
		v := s.AdditionalStagingLabelsToDownload

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "AdditionalStagingLabelsToDownload", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Information about a subscription.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/Subscription
type Subscription struct {
	_ struct{} `type:"structure"`

	// A descriptive or arbitrary ID for the subscription. This value must be unique
	// within the subscription definition version. Max length is 128 characters
	// with pattern ''[a-zA-Z0-9:_-]+''.
	Id *string `type:"string"`

	// The source of the subscription. Can be a thing ARN, a Lambda function ARN,
	// a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
	Source *string `type:"string"`

	// The MQTT topic used to route the message.
	Subject *string `type:"string"`

	// Where the message is sent to. Can be a thing ARN, a Lambda function ARN,
	// a connector ARN, 'cloud' (which represents the AWS IoT cloud), or 'GGShadowService'.
	Target *string `type:"string"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Subscription) MarshalFields(e protocol.FieldEncoder) error {
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Source != nil {
		v := *s.Source

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Source", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Subject != nil {
		v := *s.Subject

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Subject", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Target != nil {
		v := *s.Target

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Target", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about a subscription definition version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/SubscriptionDefinitionVersion
type SubscriptionDefinitionVersion struct {
	_ struct{} `type:"structure"`

	// A list of subscriptions.
	Subscriptions []Subscription `type:"list"`
}

// String returns the string representation
func (s SubscriptionDefinitionVersion) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SubscriptionDefinitionVersion) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Subscriptions) > 0 {
		v := s.Subscriptions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Subscriptions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Information about a version.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/greengrass-2017-06-07/VersionInformation
type VersionInformation struct {
	_ struct{} `type:"structure"`

	// The ARN of the version.
	Arn *string `type:"string"`

	// The time, in milliseconds since the epoch, when the version was created.
	CreationTimestamp *string `type:"string"`

	// The ID of the version.
	Id *string `type:"string"`

	// The unique ID of the version.
	Version *string `type:"string"`
}

// String returns the string representation
func (s VersionInformation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s VersionInformation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTimestamp != nil {
		v := *s.CreationTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CreationTimestamp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Version != nil {
		v := *s.Version

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Version", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
