// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request body for CreateConfiguration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfigurationRequest
type CreateConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The description of the configuration.
	Description *string `locationName:"description" type:"string"`

	// The versions of Apache Kafka with which you can use this MSK configuration.
	//
	// KafkaVersions is a required field
	KafkaVersions []string `locationName:"kafkaVersions" type:"list" required:"true"`

	// The name of the configuration.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// Contents of the server.properties file. When using the API, you must ensure
	// that the contents of the file are base64 encoded. When using the AWS Management
	// Console, the SDK, or the AWS CLI, the contents of server.properties can be
	// in plaintext.
	//
	// ServerProperties is automatically base64 encoded/decoded by the SDK.
	//
	// ServerProperties is a required field
	ServerProperties []byte `locationName:"serverProperties" type:"blob" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateConfigurationInput"}

	if s.KafkaVersions == nil {
		invalidParams.Add(aws.NewErrParamRequired("KafkaVersions"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if s.ServerProperties == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServerProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateConfigurationInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.KafkaVersions) > 0 {
		v := s.KafkaVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "kafkaVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServerProperties != nil {
		v := s.ServerProperties

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serverProperties", protocol.QuotedValue{ValueMarshaler: protocol.BytesValue(v)}, metadata)
	}
	return nil
}

// Response body for CreateConfiguration
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfigurationResponse
type CreateConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the configuration.
	Arn *string `locationName:"arn" type:"string"`

	// The time when the configuration was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"unix"`

	// Latest revision of the configuration.
	LatestRevision *ConfigurationRevision `locationName:"latestRevision" type:"structure"`

	// The name of the configuration.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s CreateConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateConfigurationOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CreationTime != nil {
		v := *s.CreationTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "creationTime", protocol.TimeValue{V: v, Format: protocol.UnixTimeFormat}, metadata)
	}
	if s.LatestRevision != nil {
		v := s.LatestRevision

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "latestRevision", v, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateConfiguration = "CreateConfiguration"

// CreateConfigurationRequest returns a request value for making API operation for
// Managed Streaming for Kafka.
//
// Creates a new MSK configuration.
//
//    // Example sending a request using CreateConfigurationRequest.
//    req := client.CreateConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kafka-2018-11-14/CreateConfiguration
func (c *Client) CreateConfigurationRequest(input *CreateConfigurationInput) CreateConfigurationRequest {
	op := &aws.Operation{
		Name:       opCreateConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/v1/configurations",
	}

	if input == nil {
		input = &CreateConfigurationInput{}
	}

	req := c.newRequest(op, input, &CreateConfigurationOutput{})
	return CreateConfigurationRequest{Request: req, Input: input, Copy: c.CreateConfigurationRequest}
}

// CreateConfigurationRequest is the request type for the
// CreateConfiguration API operation.
type CreateConfigurationRequest struct {
	*aws.Request
	Input *CreateConfigurationInput
	Copy  func(*CreateConfigurationInput) CreateConfigurationRequest
}

// Send marshals and sends the CreateConfiguration API request.
func (r CreateConfigurationRequest) Send(ctx context.Context) (*CreateConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConfigurationResponse{
		CreateConfigurationOutput: r.Request.Data.(*CreateConfigurationOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConfigurationResponse is the response type for the
// CreateConfiguration API operation.
type CreateConfigurationResponse struct {
	*CreateConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConfiguration request.
func (r *CreateConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
