// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesis

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
)

// WaitUntilStreamExists uses the Kinesis API operation
// DescribeStream to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilStreamExists(ctx context.Context, input *DescribeStreamInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilStreamExists",
		MaxAttempts: 18,
		Delay:       aws.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:   aws.SuccessWaiterState,
				Matcher: aws.PathWaiterMatch, Argument: "StreamDescription.StreamStatus",
				Expected: "ACTIVE",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *DescribeStreamInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.DescribeStreamRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}

// WaitUntilStreamNotExists uses the Kinesis API operation
// DescribeStream to wait for a condition to be met before returning.
// If the condition is not met within the max attempt window, an error will
// be returned.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Client) WaitUntilStreamNotExists(ctx context.Context, input *DescribeStreamInput, opts ...aws.WaiterOption) error {
	w := aws.Waiter{
		Name:        "WaitUntilStreamNotExists",
		MaxAttempts: 18,
		Delay:       aws.ConstantWaiterDelay(10 * time.Second),
		Acceptors: []aws.WaiterAcceptor{
			{
				State:    aws.SuccessWaiterState,
				Matcher:  aws.ErrorWaiterMatch,
				Expected: "ResourceNotFoundException",
			},
		},
		Logger: c.Config.Logger,
		NewRequest: func(opts []aws.Option) (*aws.Request, error) {
			var inCpy *DescribeStreamInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req := c.DescribeStreamRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req.Request, nil
		},
	}
	w.ApplyOptions(opts...)

	return w.Wait(ctx)
}
