// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisanalytics

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/StartApplicationRequest
type StartApplicationInput struct {
	_ struct{} `type:"structure"`

	// Name of the application.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Identifies the specific input, by ID, that the application starts consuming.
	// Amazon Kinesis Analytics starts reading the streaming source associated with
	// the input. You can also specify where in the streaming source you want Amazon
	// Kinesis Analytics to start reading.
	//
	// InputConfigurations is a required field
	InputConfigurations []InputConfiguration `type:"list" required:"true"`
}

// String returns the string representation
func (s StartApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartApplicationInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartApplicationInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.InputConfigurations == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputConfigurations"))
	}
	if s.InputConfigurations != nil {
		for i, v := range s.InputConfigurations {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "InputConfigurations", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/StartApplicationResponse
type StartApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

const opStartApplication = "StartApplication"

// StartApplicationRequest returns a request value for making API operation for
// Amazon Kinesis Analytics.
//
//
// This documentation is for version 1 of the Amazon Kinesis Data Analytics
// API, which only supports SQL applications. Version 2 of the API supports
// SQL and Java applications. For more information about version 2, see Amazon
// Kinesis Data Analytics API V2 Documentation (/kinesisanalytics/latest/apiv2/Welcome.html).
//
// Starts the specified Amazon Kinesis Analytics application. After creating
// an application, you must exclusively call this operation to start your application.
//
// After the application starts, it begins consuming the input data, processes
// it, and writes the output to the configured destination.
//
// The application status must be READY for you to start an application. You
// can get the application status in the console or using the DescribeApplication
// (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html)
// operation.
//
// After you start the application, you can stop the application from processing
// the input by calling the StopApplication (https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_StopApplication.html)
// operation.
//
// This operation requires permissions to perform the kinesisanalytics:StartApplication
// action.
//
//    // Example sending a request using StartApplicationRequest.
//    req := client.StartApplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisanalytics-2015-08-14/StartApplication
func (c *Client) StartApplicationRequest(input *StartApplicationInput) StartApplicationRequest {
	op := &aws.Operation{
		Name:       opStartApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartApplicationInput{}
	}

	req := c.newRequest(op, input, &StartApplicationOutput{})
	return StartApplicationRequest{Request: req, Input: input, Copy: c.StartApplicationRequest}
}

// StartApplicationRequest is the request type for the
// StartApplication API operation.
type StartApplicationRequest struct {
	*aws.Request
	Input *StartApplicationInput
	Copy  func(*StartApplicationInput) StartApplicationRequest
}

// Send marshals and sends the StartApplication API request.
func (r StartApplicationRequest) Send(ctx context.Context) (*StartApplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartApplicationResponse{
		StartApplicationOutput: r.Request.Data.(*StartApplicationOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartApplicationResponse is the response type for the
// StartApplication API operation.
type StartApplicationResponse struct {
	*StartApplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartApplication request.
func (r *StartApplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
