// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EncryptRequest
type EncryptInput struct {
	_ struct{} `type:"structure"`

	// Name-value pair that specifies the encryption context to be used for authenticated
	// encryption. If used here, the same value must be supplied to the Decrypt
	// API or decryption will fail. For more information, see Encryption Context
	// (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
	EncryptionContext map[string]string `type:"map"`

	// A list of grant tokens.
	//
	// For more information, see Grant Tokens (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
	// in the AWS Key Management Service Developer Guide.
	GrantTokens []string `type:"list"`

	// A unique identifier for the customer master key (CMK).
	//
	// To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias name,
	// or alias ARN. When using an alias name, prefix it with "alias/". To specify
	// a CMK in a different AWS account, you must use the key ARN or alias ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Alias name: alias/ExampleAlias
	//
	//    * Alias ARN: arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
	// get the alias name and alias ARN, use ListAliases.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`

	// Data to be encrypted.
	//
	// Plaintext is automatically base64 encoded/decoded by the SDK.
	//
	// Plaintext is a required field
	Plaintext []byte `min:"1" type:"blob" required:"true"`
}

// String returns the string representation
func (s EncryptInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "EncryptInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if s.Plaintext == nil {
		invalidParams.Add(aws.NewErrParamRequired("Plaintext"))
	}
	if s.Plaintext != nil && len(s.Plaintext) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Plaintext", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/EncryptResponse
type EncryptOutput struct {
	_ struct{} `type:"structure"`

	// The encrypted plaintext. When you use the HTTP API or the AWS CLI, the value
	// is Base64-encoded. Otherwise, it is not encoded.
	//
	// CiphertextBlob is automatically base64 encoded/decoded by the SDK.
	CiphertextBlob []byte `min:"1" type:"blob"`

	// The ID of the key used during encryption.
	KeyId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EncryptOutput) String() string {
	return awsutil.Prettify(s)
}

const opEncrypt = "Encrypt"

// EncryptRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Encrypts plaintext into ciphertext by using a customer master key (CMK).
// The Encrypt operation has two primary use cases:
//
//    * You can encrypt up to 4 kilobytes (4096 bytes) of arbitrary data such
//    as an RSA key, a database password, or other sensitive information.
//
//    * You can use the Encrypt operation to move encrypted data from one AWS
//    region to another. In the first region, generate a data key and use the
//    plaintext key to encrypt the data. Then, in the new region, call the Encrypt
//    method on same plaintext data key. Now, you can safely move the encrypted
//    data and encrypted data key to the new region, and decrypt in the new
//    region when necessary.
//
// You don't need use this operation to encrypt a data key within a region.
// The GenerateDataKey and GenerateDataKeyWithoutPlaintext operations return
// an encrypted data key.
//
// Also, you don't need to use this operation to encrypt data in your application.
// You can use the plaintext and encrypted data keys that the GenerateDataKey
// operation returns.
//
// The result of this operation varies with the key state of the CMK. For details,
// see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
// To perform this operation on a CMK in a different AWS account, specify the
// key ARN or alias ARN in the value of the KeyId parameter.
//
//    // Example sending a request using EncryptRequest.
//    req := client.EncryptRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/Encrypt
func (c *Client) EncryptRequest(input *EncryptInput) EncryptRequest {
	op := &aws.Operation{
		Name:       opEncrypt,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EncryptInput{}
	}

	req := c.newRequest(op, input, &EncryptOutput{})
	return EncryptRequest{Request: req, Input: input, Copy: c.EncryptRequest}
}

// EncryptRequest is the request type for the
// Encrypt API operation.
type EncryptRequest struct {
	*aws.Request
	Input *EncryptInput
	Copy  func(*EncryptInput) EncryptRequest
}

// Send marshals and sends the Encrypt API request.
func (r EncryptRequest) Send(ctx context.Context) (*EncryptResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &EncryptResponse{
		EncryptOutput: r.Request.Data.(*EncryptOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// EncryptResponse is the response type for the
// Encrypt API operation.
type EncryptResponse struct {
	*EncryptOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// Encrypt request.
func (r *EncryptResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
