// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDiskRequest
type AttachDiskInput struct {
	_ struct{} `type:"structure"`

	// The unique Lightsail disk name (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`

	// The disk path to expose to the instance (e.g., /dev/xvdf).
	//
	// DiskPath is a required field
	DiskPath *string `locationName:"diskPath" type:"string" required:"true"`

	// The name of the Lightsail instance where you want to utilize the storage
	// disk.
	//
	// InstanceName is a required field
	InstanceName *string `locationName:"instanceName" type:"string" required:"true"`
}

// String returns the string representation
func (s AttachDiskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AttachDiskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AttachDiskInput"}

	if s.DiskName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DiskName"))
	}

	if s.DiskPath == nil {
		invalidParams.Add(aws.NewErrParamRequired("DiskPath"))
	}

	if s.InstanceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDiskResult
type AttachDiskOutput struct {
	_ struct{} `type:"structure"`

	// An object describing the API operations.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s AttachDiskOutput) String() string {
	return awsutil.Prettify(s)
}

const opAttachDisk = "AttachDisk"

// AttachDiskRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Attaches a block storage disk to a running or stopped Lightsail instance
// and exposes it to the instance with the specified disk name.
//
// The attach disk operation supports tag-based access control via resource
// tags applied to the resource identified by diskName. For more information,
// see the Lightsail Dev Guide (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags).
//
//    // Example sending a request using AttachDiskRequest.
//    req := client.AttachDiskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/AttachDisk
func (c *Client) AttachDiskRequest(input *AttachDiskInput) AttachDiskRequest {
	op := &aws.Operation{
		Name:       opAttachDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AttachDiskInput{}
	}

	req := c.newRequest(op, input, &AttachDiskOutput{})
	return AttachDiskRequest{Request: req, Input: input, Copy: c.AttachDiskRequest}
}

// AttachDiskRequest is the request type for the
// AttachDisk API operation.
type AttachDiskRequest struct {
	*aws.Request
	Input *AttachDiskInput
	Copy  func(*AttachDiskInput) AttachDiskRequest
}

// Send marshals and sends the AttachDisk API request.
func (r AttachDiskRequest) Send(ctx context.Context) (*AttachDiskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AttachDiskResponse{
		AttachDiskOutput: r.Request.Data.(*AttachDiskOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AttachDiskResponse is the response type for the
// AttachDisk API operation.
type AttachDiskResponse struct {
	*AttachDiskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AttachDisk request.
func (r *AttachDiskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
