// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/jsonrpc"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DisassociateElasticIpRequest
type DisassociateElasticIpInput struct {
	_ struct{} `type:"structure"`

	// The Elastic IP address.
	//
	// ElasticIp is a required field
	ElasticIp *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateElasticIpInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateElasticIpInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DisassociateElasticIpInput"}

	if s.ElasticIp == nil {
		invalidParams.Add(aws.NewErrParamRequired("ElasticIp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DisassociateElasticIpOutput
type DisassociateElasticIpOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DisassociateElasticIpOutput) String() string {
	return awsutil.Prettify(s)
}

const opDisassociateElasticIp = "DisassociateElasticIp"

// DisassociateElasticIpRequest returns a request value for making API operation for
// AWS OpsWorks.
//
// Disassociates an Elastic IP address from its instance. The address remains
// registered with the stack. For more information, see Resource Management
// (http://docs.aws.amazon.com/opsworks/latest/userguide/resources.html).
//
// Required Permissions: To use this action, an IAM user must have a Manage
// permissions level for the stack, or an attached policy that explicitly grants
// permissions. For more information on user permissions, see Managing User
// Permissions (http://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html).
//
//    // Example sending a request using DisassociateElasticIpRequest.
//    req := client.DisassociateElasticIpRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/opsworks-2013-02-18/DisassociateElasticIp
func (c *Client) DisassociateElasticIpRequest(input *DisassociateElasticIpInput) DisassociateElasticIpRequest {
	op := &aws.Operation{
		Name:       opDisassociateElasticIp,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateElasticIpInput{}
	}

	req := c.newRequest(op, input, &DisassociateElasticIpOutput{})
	req.Handlers.Unmarshal.Remove(jsonrpc.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DisassociateElasticIpRequest{Request: req, Input: input, Copy: c.DisassociateElasticIpRequest}
}

// DisassociateElasticIpRequest is the request type for the
// DisassociateElasticIp API operation.
type DisassociateElasticIpRequest struct {
	*aws.Request
	Input *DisassociateElasticIpInput
	Copy  func(*DisassociateElasticIpInput) DisassociateElasticIpRequest
}

// Send marshals and sends the DisassociateElasticIp API request.
func (r DisassociateElasticIpRequest) Send(ctx context.Context) (*DisassociateElasticIpResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DisassociateElasticIpResponse{
		DisassociateElasticIpOutput: r.Request.Data.(*DisassociateElasticIpOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DisassociateElasticIpResponse is the response type for the
// DisassociateElasticIp API operation.
type DisassociateElasticIpResponse struct {
	*DisassociateElasticIpOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DisassociateElasticIp request.
func (r *DisassociateElasticIpResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
