// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package opsworkscmiface provides an interface to enable mocking the AWS OpsWorks for Chef Automate service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package opsworkscmiface

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/service/opsworkscm"
)

// ClientAPI provides an interface to enable mocking the
// opsworkscm.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // OpsWorksCM.
//    func myFunc(svc opsworkscmiface.ClientAPI) bool {
//        // Make svc.AssociateNode request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := opsworkscm.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        opsworkscmiface.ClientPI
//    }
//    func (m *mockClientClient) AssociateNode(input *opsworkscm.AssociateNodeInput) (*opsworkscm.AssociateNodeOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	AssociateNodeRequest(*opsworkscm.AssociateNodeInput) opsworkscm.AssociateNodeRequest

	CreateBackupRequest(*opsworkscm.CreateBackupInput) opsworkscm.CreateBackupRequest

	CreateServerRequest(*opsworkscm.CreateServerInput) opsworkscm.CreateServerRequest

	DeleteBackupRequest(*opsworkscm.DeleteBackupInput) opsworkscm.DeleteBackupRequest

	DeleteServerRequest(*opsworkscm.DeleteServerInput) opsworkscm.DeleteServerRequest

	DescribeAccountAttributesRequest(*opsworkscm.DescribeAccountAttributesInput) opsworkscm.DescribeAccountAttributesRequest

	DescribeBackupsRequest(*opsworkscm.DescribeBackupsInput) opsworkscm.DescribeBackupsRequest

	DescribeEventsRequest(*opsworkscm.DescribeEventsInput) opsworkscm.DescribeEventsRequest

	DescribeNodeAssociationStatusRequest(*opsworkscm.DescribeNodeAssociationStatusInput) opsworkscm.DescribeNodeAssociationStatusRequest

	DescribeServersRequest(*opsworkscm.DescribeServersInput) opsworkscm.DescribeServersRequest

	DisassociateNodeRequest(*opsworkscm.DisassociateNodeInput) opsworkscm.DisassociateNodeRequest

	ExportServerEngineAttributeRequest(*opsworkscm.ExportServerEngineAttributeInput) opsworkscm.ExportServerEngineAttributeRequest

	RestoreServerRequest(*opsworkscm.RestoreServerInput) opsworkscm.RestoreServerRequest

	StartMaintenanceRequest(*opsworkscm.StartMaintenanceInput) opsworkscm.StartMaintenanceRequest

	UpdateServerRequest(*opsworkscm.UpdateServerInput) opsworkscm.UpdateServerRequest

	UpdateServerEngineAttributesRequest(*opsworkscm.UpdateServerEngineAttributesInput) opsworkscm.UpdateServerEngineAttributesRequest

	WaitUntilNodeAssociated(context.Context, *opsworkscm.DescribeNodeAssociationStatusInput, ...aws.WaiterOption) error
}

var _ ClientAPI = (*opsworkscm.Client)(nil)
