// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pinpoint

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannelRequest
type GetAdmChannelInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"application-id" type:"string" required:"true"`
}

// String returns the string representation
func (s GetAdmChannelInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAdmChannelInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAdmChannelInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAdmChannelInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "application-id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannelResponse
type GetAdmChannelOutput struct {
	_ struct{} `type:"structure" payload:"ADMChannelResponse"`

	// Amazon Device Messaging channel definition.
	//
	// ADMChannelResponse is a required field
	ADMChannelResponse *ADMChannelResponse `type:"structure" required:"true"`
}

// String returns the string representation
func (s GetAdmChannelOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetAdmChannelOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ADMChannelResponse != nil {
		v := s.ADMChannelResponse

		metadata := protocol.Metadata{}
		e.SetFields(protocol.PayloadTarget, "ADMChannelResponse", v, metadata)
	}
	return nil
}

const opGetAdmChannel = "GetAdmChannel"

// GetAdmChannelRequest returns a request value for making API operation for
// Amazon Pinpoint.
//
// Get an ADM channel.
//
//    // Example sending a request using GetAdmChannelRequest.
//    req := client.GetAdmChannelRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pinpoint-2016-12-01/GetAdmChannel
func (c *Client) GetAdmChannelRequest(input *GetAdmChannelInput) GetAdmChannelRequest {
	op := &aws.Operation{
		Name:       opGetAdmChannel,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apps/{application-id}/channels/adm",
	}

	if input == nil {
		input = &GetAdmChannelInput{}
	}

	req := c.newRequest(op, input, &GetAdmChannelOutput{})
	return GetAdmChannelRequest{Request: req, Input: input, Copy: c.GetAdmChannelRequest}
}

// GetAdmChannelRequest is the request type for the
// GetAdmChannel API operation.
type GetAdmChannelRequest struct {
	*aws.Request
	Input *GetAdmChannelInput
	Copy  func(*GetAdmChannelInput) GetAdmChannelRequest
}

// Send marshals and sends the GetAdmChannel API request.
func (r GetAdmChannelRequest) Send(ctx context.Context) (*GetAdmChannelResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAdmChannelResponse{
		GetAdmChannelOutput: r.Request.Data.(*GetAdmChannelOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAdmChannelResponse is the response type for the
// GetAdmChannel API operation.
type GetAdmChannelResponse struct {
	*GetAdmChannelOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAdmChannel request.
func (r *GetAdmChannelResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
