// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package pricing

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetAttributeValuesRequest
type GetAttributeValuesInput struct {
	_ struct{} `type:"structure"`

	// The name of the attribute that you want to retrieve the values for, such
	// as volumeType.
	//
	// AttributeName is a required field
	AttributeName *string `type:"string" required:"true"`

	// The maximum number of results to return in response.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token that indicates the next set of results that you want
	// to retrieve.
	NextToken *string `type:"string"`

	// The service code for the service whose attributes you want to retrieve. For
	// example, if you want the retrieve an EC2 attribute, use AmazonEC2.
	//
	// ServiceCode is a required field
	ServiceCode *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetAttributeValuesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAttributeValuesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetAttributeValuesInput"}

	if s.AttributeName == nil {
		invalidParams.Add(aws.NewErrParamRequired("AttributeName"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if s.ServiceCode == nil {
		invalidParams.Add(aws.NewErrParamRequired("ServiceCode"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetAttributeValuesResponse
type GetAttributeValuesOutput struct {
	_ struct{} `type:"structure"`

	// The list of values for an attribute. For example, Throughput Optimized HDD
	// and Provisioned IOPS are two available values for the AmazonEC2 volumeType.
	AttributeValues []AttributeValue `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetAttributeValuesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAttributeValues = "GetAttributeValues"

// GetAttributeValuesRequest returns a request value for making API operation for
// AWS Price List Service.
//
// Returns a list of attribute values. Attibutes are similar to the details
// in a Price List API offer file. For a list of available attributes, see Offer
// File Definitions (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/reading-an-offer.html#pps-defs)
// in the AWS Billing and Cost Management User Guide (http://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-what-is.html).
//
//    // Example sending a request using GetAttributeValuesRequest.
//    req := client.GetAttributeValuesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/pricing-2017-10-15/GetAttributeValues
func (c *Client) GetAttributeValuesRequest(input *GetAttributeValuesInput) GetAttributeValuesRequest {
	op := &aws.Operation{
		Name:       opGetAttributeValues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetAttributeValuesInput{}
	}

	req := c.newRequest(op, input, &GetAttributeValuesOutput{})
	return GetAttributeValuesRequest{Request: req, Input: input, Copy: c.GetAttributeValuesRequest}
}

// GetAttributeValuesRequest is the request type for the
// GetAttributeValues API operation.
type GetAttributeValuesRequest struct {
	*aws.Request
	Input *GetAttributeValuesInput
	Copy  func(*GetAttributeValuesInput) GetAttributeValuesRequest
}

// Send marshals and sends the GetAttributeValues API request.
func (r GetAttributeValuesRequest) Send(ctx context.Context) (*GetAttributeValuesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAttributeValuesResponse{
		GetAttributeValuesOutput: r.Request.Data.(*GetAttributeValuesOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetAttributeValuesRequestPaginator returns a paginator for GetAttributeValues.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetAttributeValuesRequest(input)
//   p := pricing.NewGetAttributeValuesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetAttributeValuesPaginator(req GetAttributeValuesRequest) GetAttributeValuesPaginator {
	return GetAttributeValuesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetAttributeValuesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetAttributeValuesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetAttributeValuesPaginator struct {
	aws.Pager
}

func (p *GetAttributeValuesPaginator) CurrentPage() *GetAttributeValuesOutput {
	return p.Pager.CurrentPage().(*GetAttributeValuesOutput)
}

// GetAttributeValuesResponse is the response type for the
// GetAttributeValues API operation.
type GetAttributeValuesResponse struct {
	*GetAttributeValuesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAttributeValues request.
func (r *GetAttributeValuesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
