// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroupMessage
type DeleteClusterSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the cluster subnet group name to be deleted.
	//
	// ClusterSubnetGroupName is a required field
	ClusterSubnetGroupName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteClusterSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClusterSubnetGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteClusterSubnetGroupInput"}

	if s.ClusterSubnetGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterSubnetGroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroupOutput
type DeleteClusterSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteClusterSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteClusterSubnetGroup = "DeleteClusterSubnetGroup"

// DeleteClusterSubnetGroupRequest returns a request value for making API operation for
// Amazon Redshift.
//
// Deletes the specified cluster subnet group.
//
//    // Example sending a request using DeleteClusterSubnetGroupRequest.
//    req := client.DeleteClusterSubnetGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/DeleteClusterSubnetGroup
func (c *Client) DeleteClusterSubnetGroupRequest(input *DeleteClusterSubnetGroupInput) DeleteClusterSubnetGroupRequest {
	op := &aws.Operation{
		Name:       opDeleteClusterSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteClusterSubnetGroupInput{}
	}

	req := c.newRequest(op, input, &DeleteClusterSubnetGroupOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteClusterSubnetGroupRequest{Request: req, Input: input, Copy: c.DeleteClusterSubnetGroupRequest}
}

// DeleteClusterSubnetGroupRequest is the request type for the
// DeleteClusterSubnetGroup API operation.
type DeleteClusterSubnetGroupRequest struct {
	*aws.Request
	Input *DeleteClusterSubnetGroupInput
	Copy  func(*DeleteClusterSubnetGroupInput) DeleteClusterSubnetGroupRequest
}

// Send marshals and sends the DeleteClusterSubnetGroup API request.
func (r DeleteClusterSubnetGroupRequest) Send(ctx context.Context) (*DeleteClusterSubnetGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteClusterSubnetGroupResponse{
		DeleteClusterSubnetGroupOutput: r.Request.Data.(*DeleteClusterSubnetGroupOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteClusterSubnetGroupResponse is the response type for the
// DeleteClusterSubnetGroup API operation.
type DeleteClusterSubnetGroupResponse struct {
	*DeleteClusterSubnetGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteClusterSubnetGroup request.
func (r *DeleteClusterSubnetGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
