// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTaggingRequest
type PutObjectTaggingInput struct {
	_ struct{} `type:"structure" payload:"Tagging"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`

	// Key is a required field
	Key *string `location:"uri" locationName:"Key" min:"1" type:"string" required:"true"`

	// Tagging is a required field
	Tagging *Tagging `locationName:"Tagging" type:"structure" required:"true" xmlURI:"http://s3.amazonaws.com/doc/2006-03-01/"`

	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation
func (s PutObjectTaggingInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutObjectTaggingInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutObjectTaggingInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if s.Key == nil {
		invalidParams.Add(aws.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if s.Tagging == nil {
		invalidParams.Add(aws.NewErrParamRequired("Tagging"))
	}
	if s.Tagging != nil {
		if err := s.Tagging.Validate(); err != nil {
			invalidParams.AddNested("Tagging", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *PutObjectTaggingInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectTaggingInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Key", protocol.StringValue(v), metadata)
	}
	if s.Tagging != nil {
		v := s.Tagging

		metadata := protocol.Metadata{XMLNamespaceURI: "http://s3.amazonaws.com/doc/2006-03-01/"}
		e.SetFields(protocol.PayloadTarget, "Tagging", v, metadata)
	}
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "versionId", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTaggingOutput
type PutObjectTaggingOutput struct {
	_ struct{} `type:"structure"`

	VersionId *string `location:"header" locationName:"x-amz-version-id" type:"string"`
}

// String returns the string representation
func (s PutObjectTaggingOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutObjectTaggingOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.VersionId != nil {
		v := *s.VersionId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "x-amz-version-id", protocol.StringValue(v), metadata)
	}
	return nil
}

const opPutObjectTagging = "PutObjectTagging"

// PutObjectTaggingRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Sets the supplied tag-set to an object that already exists in a bucket
//
//    // Example sending a request using PutObjectTaggingRequest.
//    req := client.PutObjectTaggingRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/PutObjectTagging
func (c *Client) PutObjectTaggingRequest(input *PutObjectTaggingInput) PutObjectTaggingRequest {
	op := &aws.Operation{
		Name:       opPutObjectTagging,
		HTTPMethod: "PUT",
		HTTPPath:   "/{Bucket}/{Key+}?tagging",
	}

	if input == nil {
		input = &PutObjectTaggingInput{}
	}

	req := c.newRequest(op, input, &PutObjectTaggingOutput{})
	return PutObjectTaggingRequest{Request: req, Input: input, Copy: c.PutObjectTaggingRequest}
}

// PutObjectTaggingRequest is the request type for the
// PutObjectTagging API operation.
type PutObjectTaggingRequest struct {
	*aws.Request
	Input *PutObjectTaggingInput
	Copy  func(*PutObjectTaggingInput) PutObjectTaggingRequest
}

// Send marshals and sends the PutObjectTagging API request.
func (r PutObjectTaggingRequest) Send(ctx context.Context) (*PutObjectTaggingResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutObjectTaggingResponse{
		PutObjectTaggingOutput: r.Request.Data.(*PutObjectTaggingOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutObjectTaggingResponse is the response type for the
// PutObjectTagging API operation.
type PutObjectTaggingResponse struct {
	*PutObjectTaggingOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutObjectTagging request.
func (r *PutObjectTaggingResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
