// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package securityhub

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsightRequest
type CreateInsightInput struct {
	_ struct{} `type:"structure"`

	// A collection of attributes that are applied to all active Security Hub-aggregated
	// findings and that result in a subset of findings that are included in this
	// insight.
	//
	// Filters is a required field
	Filters *AwsSecurityFindingFilters `type:"structure" required:"true"`

	// The attribute by which the insight's findings are grouped. This attribute
	// is used as a findings aggregator for the purposes of viewing and managing
	// multiple related findings under a single operand.
	//
	// GroupByAttribute is a required field
	GroupByAttribute *string `type:"string" required:"true"`

	// The user-defined name that identifies the insight that you want to create.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInsightInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInsightInput"}

	if s.Filters == nil {
		invalidParams.Add(aws.NewErrParamRequired("Filters"))
	}

	if s.GroupByAttribute == nil {
		invalidParams.Add(aws.NewErrParamRequired("GroupByAttribute"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateInsightInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Filters != nil {
		v := s.Filters

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Filters", v, metadata)
	}
	if s.GroupByAttribute != nil {
		v := *s.GroupByAttribute

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "GroupByAttribute", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsightResponse
type CreateInsightOutput struct {
	_ struct{} `type:"structure"`

	// The ARN Of the created insight.
	//
	// InsightArn is a required field
	InsightArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInsightOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateInsightOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.InsightArn != nil {
		v := *s.InsightArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "InsightArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateInsight = "CreateInsight"

// CreateInsightRequest returns a request value for making API operation for
// AWS SecurityHub.
//
// Creates an insight, which is a consolidation of findings that identifies
// a security area that requires attention or intervention.
//
//    // Example sending a request using CreateInsightRequest.
//    req := client.CreateInsightRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/securityhub-2018-10-26/CreateInsight
func (c *Client) CreateInsightRequest(input *CreateInsightInput) CreateInsightRequest {
	op := &aws.Operation{
		Name:       opCreateInsight,
		HTTPMethod: "POST",
		HTTPPath:   "/insights",
	}

	if input == nil {
		input = &CreateInsightInput{}
	}

	req := c.newRequest(op, input, &CreateInsightOutput{})
	return CreateInsightRequest{Request: req, Input: input, Copy: c.CreateInsightRequest}
}

// CreateInsightRequest is the request type for the
// CreateInsight API operation.
type CreateInsightRequest struct {
	*aws.Request
	Input *CreateInsightInput
	Copy  func(*CreateInsightInput) CreateInsightRequest
}

// Send marshals and sends the CreateInsight API request.
func (r CreateInsightRequest) Send(ctx context.Context) (*CreateInsightResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateInsightResponse{
		CreateInsightOutput: r.Request.Data.(*CreateInsightOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateInsightResponse is the response type for the
// CreateInsight API operation.
type CreateInsightResponse struct {
	*CreateInsightOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateInsight request.
func (r *CreateInsightResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
