// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package serverlessapplicationrepository

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicyRequest
type PutApplicationPolicyInput struct {
	_ struct{} `type:"structure"`

	// ApplicationId is a required field
	ApplicationId *string `location:"uri" locationName:"applicationId" type:"string" required:"true"`

	// Statements is a required field
	Statements []ApplicationPolicyStatement `locationName:"statements" type:"list" required:"true"`
}

// String returns the string representation
func (s PutApplicationPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutApplicationPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "PutApplicationPolicyInput"}

	if s.ApplicationId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationId"))
	}

	if s.Statements == nil {
		invalidParams.Add(aws.NewErrParamRequired("Statements"))
	}
	if s.Statements != nil {
		for i, v := range s.Statements {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Statements", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutApplicationPolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if len(s.Statements) > 0 {
		v := s.Statements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "statements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.ApplicationId != nil {
		v := *s.ApplicationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "applicationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicyResponse
type PutApplicationPolicyOutput struct {
	_ struct{} `type:"structure"`

	Statements []ApplicationPolicyStatement `locationName:"statements" type:"list"`
}

// String returns the string representation
func (s PutApplicationPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PutApplicationPolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Statements) > 0 {
		v := s.Statements

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "statements", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opPutApplicationPolicy = "PutApplicationPolicy"

// PutApplicationPolicyRequest returns a request value for making API operation for
// AWSServerlessApplicationRepository.
//
// Sets the permission policy for an application. For the list of actions supported
// for this operation, see Application Permissions (https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions) .
//
//    // Example sending a request using PutApplicationPolicyRequest.
//    req := client.PutApplicationPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/serverlessrepo-2017-09-08/PutApplicationPolicy
func (c *Client) PutApplicationPolicyRequest(input *PutApplicationPolicyInput) PutApplicationPolicyRequest {
	op := &aws.Operation{
		Name:       opPutApplicationPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{applicationId}/policy",
	}

	if input == nil {
		input = &PutApplicationPolicyInput{}
	}

	req := c.newRequest(op, input, &PutApplicationPolicyOutput{})
	return PutApplicationPolicyRequest{Request: req, Input: input, Copy: c.PutApplicationPolicyRequest}
}

// PutApplicationPolicyRequest is the request type for the
// PutApplicationPolicy API operation.
type PutApplicationPolicyRequest struct {
	*aws.Request
	Input *PutApplicationPolicyInput
	Copy  func(*PutApplicationPolicyInput) PutApplicationPolicyRequest
}

// Send marshals and sends the PutApplicationPolicy API request.
func (r PutApplicationPolicyRequest) Send(ctx context.Context) (*PutApplicationPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &PutApplicationPolicyResponse{
		PutApplicationPolicyOutput: r.Request.Data.(*PutApplicationPolicyOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// PutApplicationPolicyResponse is the response type for the
// PutApplicationPolicy API operation.
type PutApplicationPolicyResponse struct {
	*PutApplicationPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// PutApplicationPolicy request.
func (r *PutApplicationPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
